/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.textserialize.item;

import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.search.query.textserialize.item.ItemArguments;
import com.yahoo.search.query.textserialize.item.ItemContext;
import com.yahoo.search.query.textserialize.item.TypeCheck;
import com.yahoo.search.query.textserialize.serializer.DispatchForm;
import com.yahoo.search.query.textserialize.serializer.ItemIdMapper;
import java.util.List;
import java.util.Map;

public class ItemInitializer {
    private static final String indexProperty = "index";
    private static final String idProperty = "id";
    private static final String significanceProperty = "significance";
    private static final String uniqueIdProperty = "uniqueId";
    private static final String weightProperty = "weight";

    public static void initialize(Item item, ItemArguments arguments, ItemContext itemContext) {
        ItemInitializer.storeIdInContext(item, arguments.properties, itemContext);
        Object weight = arguments.properties.get(weightProperty);
        if (weight != null) {
            TypeCheck.ensureInstanceOf(weight, Number.class);
            item.setWeight(((Number)weight).intValue());
        }
        if (item instanceof TaggableItem) {
            ItemInitializer.initializeTaggableItem((TaggableItem)((Object)item), arguments, itemContext);
        }
        if (item instanceof IndexedItem) {
            ItemInitializer.initializeIndexedItem((IndexedItem)((Object)item), arguments, itemContext);
        }
    }

    private static void storeIdInContext(Item item, Map<?, ?> properties, ItemContext itemContext) {
        Object id = properties.get(idProperty);
        if (id != null) {
            TypeCheck.ensureInstanceOf(id, String.class);
            itemContext.setItemId((String)id, item);
        }
    }

    private static void initializeTaggableItem(TaggableItem item, ItemArguments arguments, ItemContext itemContext) {
        Object uniqueId;
        Object significance;
        Object connectivity = arguments.properties.get("connectivity");
        if (connectivity != null) {
            ItemInitializer.storeConnectivityInContext(item, connectivity, itemContext);
        }
        if ((significance = arguments.properties.get(significanceProperty)) != null) {
            TypeCheck.ensureInstanceOf(significance, Number.class);
            item.setSignificance(((Number)significance).doubleValue());
        }
        if ((uniqueId = arguments.properties.get(uniqueIdProperty)) != null) {
            TypeCheck.ensureInstanceOf(uniqueId, Number.class);
            item.setUniqueID(((Number)uniqueId).intValue());
        }
    }

    private static void initializeIndexedItem(IndexedItem indexedItem, ItemArguments arguments, ItemContext itemContext) {
        Object index = arguments.properties.get(indexProperty);
        if (index != null) {
            TypeCheck.ensureInstanceOf(index, String.class);
            indexedItem.setIndexName((String)index);
        }
    }

    private static void storeConnectivityInContext(TaggableItem item, Object connectivity, ItemContext itemContext) {
        TypeCheck.ensureInstanceOf(connectivity, List.class);
        List connectivityList = (List)connectivity;
        if (connectivityList.size() != 2) {
            throw new IllegalArgumentException("Expected two elements for connectivity, got " + connectivityList.size());
        }
        Object id = connectivityList.get(0);
        Object strength = connectivityList.get(1);
        TypeCheck.ensureInstanceOf(id, String.class);
        TypeCheck.ensureInstanceOf(strength, Number.class);
        itemContext.setConnectivity(item, (String)id, ((Number)strength).doubleValue());
    }

    public static void initializeForm(DispatchForm form, Item item, ItemIdMapper itemIdMapper) {
        if (item.getWeight() != 100) {
            form.setProperty(weightProperty, item.getWeight());
        }
        if (item instanceof IndexedItem) {
            ItemInitializer.initializeIndexedForm(form, (IndexedItem)((Object)item));
        }
        if (item instanceof TaggableItem) {
            ItemInitializer.initializeTaggableForm(form, (TaggableItem)((Object)item), itemIdMapper);
        }
        ItemInitializer.initializeFormWithIdIfConnected(form, item, itemIdMapper);
    }

    private static void initializeFormWithIdIfConnected(DispatchForm form, Item item, ItemIdMapper itemIdMapper) {
        if (item.hasConnectivityBackLink()) {
            form.setProperty(idProperty, itemIdMapper.getId(item));
        }
    }

    private static void initializeTaggableForm(DispatchForm form, TaggableItem taggableItem, ItemIdMapper itemIdMapper) {
        Item connectedItem = taggableItem.getConnectedItem();
        if (connectedItem != null) {
            form.setProperty("connectivity", List.of(itemIdMapper.getId(connectedItem), Double.valueOf(taggableItem.getConnectivity())));
        }
        if (taggableItem.hasExplicitSignificance()) {
            form.setProperty(significanceProperty, taggableItem.getSignificance());
        }
        if (taggableItem.hasUniqueID()) {
            form.setProperty(uniqueIdProperty, taggableItem.getUniqueID());
        }
    }

    private static void initializeIndexedForm(DispatchForm form, IndexedItem item) {
        String index = item.getIndexName();
        if (!index.isEmpty()) {
            form.setProperty(indexProperty, index);
        }
    }
}

