/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.textserialize.item;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.search.query.textserialize.item.CompositeConverter;
import com.yahoo.search.query.textserialize.item.ItemArguments;
import com.yahoo.search.query.textserialize.item.ItemContext;
import com.yahoo.search.query.textserialize.item.ListUtil;
import com.yahoo.search.query.textserialize.item.TypeCheck;
import java.util.List;

public class AndNotRestConverter
extends CompositeConverter<NotItem> {
    static final String andNotRest = "AND-NOT-REST";

    public AndNotRestConverter() {
        super(NotItem.class);
    }

    @Override
    protected void addChildren(NotItem item, ItemArguments arguments, ItemContext context) {
        if (this.firstIsNull(arguments.children)) {
            this.addNegativeItems(item, arguments.children);
        } else {
            this.addItems(item, arguments.children);
        }
    }

    private void addNegativeItems(NotItem notItem, List<Object> children) {
        for (Object child : ListUtil.butFirst(children)) {
            TypeCheck.ensureInstanceOf(child, Item.class);
            notItem.addNegativeItem((Item)child);
        }
    }

    private void addItems(NotItem notItem, List<Object> children) {
        for (Object child : children) {
            TypeCheck.ensureInstanceOf(child, Item.class);
            notItem.addItem((Item)child);
        }
    }

    private boolean firstIsNull(List<Object> children) {
        return !children.isEmpty() && ListUtil.first(children) == null;
    }

    @Override
    protected String getFormName(Item item) {
        return andNotRest;
    }
}

