/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.engine;

import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.Condition;

public class Choicepoint {
    private boolean open = true;
    private int tries = 0;
    private Condition condition;
    private State state;
    private RuleEvaluation owner;

    public Choicepoint(RuleEvaluation e, Condition condition) {
        this.owner = e;
        this.state = new State(this, e);
        this.condition = condition;
        if (e.getTraceLevel() >= 5) {
            e.trace(5, "Added choice point at " + String.valueOf(e.currentItem()) + " for '" + String.valueOf(condition) + "'");
        }
    }

    public Condition getCondition() {
        return this.condition;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.open = false;
    }

    public int tryCount() {
        return this.tries;
    }

    public void addTry() {
        ++this.tries;
    }

    public void backtrack() {
        this.state.backtrack(this.owner);
        if (this.owner.getTraceLevel() >= 5) {
            this.owner.trace(5, "Backtracked to " + String.valueOf(this.owner.currentItem()) + " for '" + String.valueOf(this.condition) + "'");
        }
    }

    public void backtrackPosition() {
        this.state.backtrackPosition(this.owner);
    }

    public void updateState() {
        this.state.updateState(this.owner);
    }

    public State getState() {
        return this.state;
    }

    public static final class State {
        private int position = 0;
        private int referencedMatchCount = 0;
        private int nonreferencedMatchCount = 0;

        public State(Choicepoint choicepoint, RuleEvaluation evaluation) {
            this.updateState(evaluation);
        }

        public void updateState(RuleEvaluation evaluation) {
            this.position = evaluation.currentPosition();
            this.referencedMatchCount = evaluation.getReferencedMatchCount();
            this.nonreferencedMatchCount = evaluation.getNonreferencedMatchCount();
        }

        public void backtrack(RuleEvaluation e) {
            this.backtrackPosition(e);
            if (e.referencedMatches().size() > this.referencedMatchCount) {
                e.referencedMatches().subList(this.referencedMatchCount, e.referencedMatches().size()).clear();
            }
            if (e.nonreferencedMatches().size() > this.nonreferencedMatchCount) {
                e.nonreferencedMatches().subList(this.nonreferencedMatchCount, e.nonreferencedMatches().size()).clear();
            }
        }

        public void backtrackPosition(RuleEvaluation e) {
            e.setPosition(this.position);
        }

        public int getPosition() {
            return this.position;
        }

        public int getReferencedMatchCount() {
            return this.referencedMatchCount;
        }

        public int getNonreferencedMatchCount() {
            return this.nonreferencedMatchCount;
        }
    }
}

