/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.Properties;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
public class FieldCollapsingSearcher
extends Searcher {
    private static final CompoundName collapse = CompoundName.from((String)"collapse");
    private static final CompoundName collapseField = CompoundName.from((String)"collapsefield");
    private static final CompoundName collapseSize = CompoundName.from((String)"collapsesize");
    private static final CompoundName collapseSummaryName = CompoundName.from((String)"collapse.summary");
    private static final String separator = ",";
    private static final int maxQueries = 4;
    private int defaultCollapseSize;
    private double extraFactor;

    public FieldCollapsingSearcher() {
        this(1, 2.0);
    }

    @Inject
    public FieldCollapsingSearcher(QrSearchersConfig config) {
        QrSearchersConfig.Com.Yahoo.Prelude.Searcher.FieldCollapsingSearcher searcherConfig = config.com().yahoo().prelude().searcher().FieldCollapsingSearcher();
        this.init(searcherConfig.collapsesize(), searcherConfig.extrafactor());
    }

    public FieldCollapsingSearcher(int collapseSize, double extraFactor) {
        this.init(collapseSize, extraFactor);
    }

    private void init(int collapseSize, double extraFactor) {
        this.defaultCollapseSize = collapseSize;
        this.extraFactor = extraFactor;
        if (extraFactor < 1.0) {
            throw new IllegalArgumentException("FieldCollapsingSearcher: extraFactor " + extraFactor + " should be >= 1.0");
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result resultSource;
        boolean wantAnotherQuery;
        String collapseFieldParam = query.properties().getString(collapseField);
        if (collapseFieldParam == null) {
            return execution.search(query);
        }
        Object[] collapseFields = collapseFieldParam.split(separator);
        int globalCollapseSize = query.properties().getInteger(collapseSize, this.defaultCollapseSize);
        query.properties().set(collapse, "0");
        int wantedHits = query.getOffset() + query.getHits();
        int hitsToRequest = query.getHits() != 0 ? (int)Math.ceil((double)(wantedHits + 1) * this.extraFactor) : 0;
        int nextOffset = 0;
        int hitsAfterCollapse = 0;
        boolean moreHitsAvailable = true;
        HashMap<String, Integer> knownCollapses = new HashMap<String, Integer>();
        Result result = new Result(query);
        int performedQueries = 0;
        String collapseSummary = query.properties().getString(collapseSummaryName);
        String summaryClass = collapseSummary == null ? query.getPresentation().getSummary() : collapseSummary;
        query.trace("Collapsing by '" + Arrays.toString(collapseFields) + "' using summary '" + collapseSummary + "'", 2);
        do {
            if (performedQueries > 0) {
                query.trace("Collapsing: retry " + performedQueries + ", only has " + hitsAfterCollapse + " hits, wanted " + wantedHits, 2);
            }
            resultSource = this.search(query.clone(), execution, nextOffset, hitsToRequest);
            this.fill(resultSource, summaryClass, execution);
            this.collapse(result, knownCollapses, resultSource, (String[])collapseFields, query.properties(), globalCollapseSize);
            hitsAfterCollapse = result.getHitCount();
            if (resultSource.getTotalHitCount() < (long)(hitsToRequest + nextOffset)) {
                moreHitsAvailable = false;
            }
            nextOffset += hitsToRequest;
            if (hitsAfterCollapse < wantedHits) {
                hitsToRequest = (int)Math.ceil((double)hitsToRequest * this.extraFactor);
            }
            boolean bl = wantAnotherQuery = hitsToRequest != 0 && hitsAfterCollapse < wantedHits && moreHitsAvailable;
        } while (wantAnotherQuery && ++performedQueries <= 4);
        if (wantAnotherQuery) {
            query.trace("Collapsing: giving up after " + performedQueries + " performed queries, collapsing removed too many hits", 1);
        }
        result.mergeWith(resultSource);
        result.hits().trim(query.getOffset(), query.getHits());
        query.properties().set(collapse, "1");
        if (!moreHitsAvailable) {
            result.setTotalHitCount(hitsAfterCollapse);
        }
        return result;
    }

    private Result search(Query query, Execution execution, int offset, int hits) {
        query.setOffset(offset);
        query.setHits(hits);
        return execution.search(query);
    }

    private void collapse(Result result, Map<String, Integer> knownCollapses, Result resultSource, String[] collapseFields, Properties queryProperties, int globalCollapseSize) {
        for (Hit unknownHit : resultSource.hits()) {
            if (!(unknownHit instanceof FastHit)) {
                result.hits().add(unknownHit);
                continue;
            }
            FastHit hit = (FastHit)unknownHit;
            boolean addHit = true;
            for (String collapseField : collapseFields) {
                String collapseId;
                Object peek = hit.getField(collapseField);
                String string = collapseId = peek != null ? peek.toString() : null;
                if (collapseId == null) continue;
                String collapseKey = collapseField + "@" + collapseId;
                if (knownCollapses.containsKey(collapseKey)) {
                    int collapseSize;
                    int numHitsThisField = knownCollapses.get(collapseKey);
                    if (numHitsThisField < (collapseSize = this.getCollapseSize(queryProperties, collapseField, globalCollapseSize))) {
                        knownCollapses.put(collapseKey, ++numHitsThisField);
                        continue;
                    }
                    addHit = false;
                    break;
                }
                knownCollapses.put(collapseKey, 1);
            }
            if (!addHit) continue;
            result.hits().add(hit);
        }
    }

    private int getCollapseSize(Properties properties, String fieldName, int globalCollapseSize) {
        Integer fieldCollapseSize = properties.getInteger(collapseSize.append(fieldName));
        return fieldCollapseSize != null ? fieldCollapseSize : globalCollapseSize;
    }
}

