/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.ToProtobuf;
import com.yahoo.prelude.query.parser.Token;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import com.yahoo.protect.Validator;
import java.nio.ByteBuffer;
import java.util.Objects;

public class WordItem
extends TermItem {
    private boolean words = true;
    private boolean stemmed = false;
    private boolean fromSegmented = false;
    private int segmentIndex = 0;
    private String word;

    public WordItem(String word) {
        this(word, "");
    }

    public WordItem(String word, String indexName) {
        this(word, indexName, false, null);
    }

    public WordItem(String word, boolean isFromQuery) {
        this(word, null, isFromQuery, null);
    }

    public WordItem(String word, String indexName, boolean isFromQuery) {
        this(word, indexName, isFromQuery, null);
    }

    public WordItem(Token word, boolean isFromQuery) {
        this(word.toString(), "", isFromQuery, word.substring);
    }

    public WordItem(String word, boolean isFromQuery, Substring origin) {
        this(word, "", isFromQuery, origin);
    }

    public WordItem(String word, String indexName, boolean isFromQuery, Substring origin) {
        super(indexName, isFromQuery, origin);
        this.setWord(word);
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.WORD;
    }

    @Override
    public String getName() {
        return "WORD";
    }

    public void setWord(String word) {
        Validator.ensureNotNull((String)"The word of a word item", (Object)word);
        Validator.ensureNonEmpty((String)"The word of a word item", (String)word);
        this.word = word;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        WordItem.putString(this.getEncodedWord(), buffer);
    }

    protected String getEncodedWord() {
        return this.getIndexedString();
    }

    public String getWord() {
        return this.word;
    }

    @Override
    public String stringValue() {
        return this.word;
    }

    @Override
    public void setValue(String value) {
        this.setWord(value);
    }

    @Override
    public String getRawWord() {
        if (this.getOrigin() != null) {
            return this.getOrigin().getValue();
        }
        return this.word;
    }

    @Override
    public boolean isStemmed() {
        return this.stemmed;
    }

    public void setStemmed(boolean stemmed) {
        this.stemmed = stemmed;
    }

    public boolean isFromSegmented() {
        return this.fromSegmented;
    }

    public void setFromSegmented(boolean fromSegmented) {
        this.fromSegmented = fromSegmented;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public void setSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        WordItem other = (WordItem)o;
        if (this.words != other.words) {
            return false;
        }
        if (this.stemmed != other.stemmed) {
            return false;
        }
        if (this.fromSegmented != other.fromSegmented) {
            return false;
        }
        if (this.segmentIndex != other.segmentIndex) {
            return false;
        }
        return Objects.equals(this.word, other.word);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.words, this.stemmed, this.fromSegmented, this.segmentIndex, this.word);
    }

    @Override
    public int getNumWords() {
        return 1;
    }

    @Override
    public String getIndexedString() {
        return this.word;
    }

    @Override
    public boolean isWords() {
        return this.words;
    }

    public void setWords(boolean words) {
        this.words = words;
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("fromSegmented", this.fromSegmented);
        discloser.addProperty("segmentIndex", this.segmentIndex);
        discloser.addProperty("stemmed", this.stemmed);
        discloser.addProperty("words", this.words);
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        SearchProtocol.ItemWordTerm.Builder builder = SearchProtocol.ItemWordTerm.newBuilder();
        builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
        builder.setWord(this.getEncodedWord());
        return SearchProtocol.QueryTreeItem.newBuilder().setItemWordTerm(builder.build()).build();
    }
}

