/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.RootItem;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import com.yahoo.protect.Validator;
import com.yahoo.search.query.QueryTree;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;

public abstract class CompositeItem
extends Item {
    private List<Item> subitems = new ArrayList<Item>(4);

    @Override
    public void setIndexName(String index) {
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            item.setIndexName(index);
        }
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        for (Item item : this.subitems) {
            discloser.addChild(item);
        }
    }

    public void ensureNotInSubtree(CompositeItem item) {
        for (CompositeItem i = this; i != null; i = i.getParent()) {
            if (i != item) continue;
            throw new IllegalArgumentException("Cannot add '" + String.valueOf(item) + "' to '" + String.valueOf(this) + "' as it would create a cycle");
        }
    }

    public void addItem(Item item) {
        this.adding(item);
        this.subitems.add(item);
    }

    protected void adding(Item item) {
        Validator.ensureNotNull((String)"A composite item child", (Object)item);
        Validator.ensure((String)"Attempted to add a composite to itself", (item != this ? 1 : 0) != 0);
        Validator.ensure((String)"Cannot add a RootItem as a child", (!(item instanceof RootItem) ? 1 : 0) != 0);
        if (item instanceof CompositeItem) {
            this.ensureNotInSubtree((CompositeItem)item);
        }
        item.setParent(this);
    }

    public void addItem(int index, Item item) {
        if (index > this.subitems.size() || index < 0) {
            throw new IndexOutOfBoundsException("Could not add a subitem at position " + index + " to " + String.valueOf(this));
        }
        this.adding(item);
        this.subitems.add(index, item);
    }

    public Item getItem(int index) {
        return this.subitems.get(index);
    }

    public Item setItem(int index, Item item) {
        if (index >= this.subitems.size() || index < 0) {
            throw new IndexOutOfBoundsException("Could not add a subitem at position " + index + " to " + String.valueOf(this));
        }
        this.adding(item);
        Item old = this.subitems.set(index, item);
        if (old != item) {
            this.removing(old);
        }
        return old;
    }

    public int getItemIndex(Item item) {
        return this.subitems.indexOf(item);
    }

    public Item removeItem(int index) {
        Item item = this.subitems.remove(index);
        this.removing(item);
        return item;
    }

    private void removing(Item item) {
        if (item == null) {
            return;
        }
        if (item.getParent() == this) {
            item.setParent(null);
        }
    }

    public boolean removeItem(Item item) {
        boolean removed = this.subitems.remove(item);
        if (removed) {
            this.removing(item);
        }
        return removed;
    }

    public int getItemCount() {
        return this.subitems.size();
    }

    public ListIterator<Item> getItemIterator() {
        return new ListIteratorWrapper(this);
    }

    public List<Item> items() {
        return Collections.unmodifiableList(this.subitems);
    }

    @Override
    public int encode(ByteBuffer buffer) {
        this.encodeThis(buffer);
        int itemCount = 1;
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item subitem = (Item)i.next();
            itemCount += subitem.encode(buffer);
        }
        return itemCount;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.encodingArity(), (ByteBuffer)buffer);
    }

    protected int encodingArity() {
        return this.subitems.size();
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            buffer.append(item.toString());
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
    }

    @Override
    protected boolean shouldParenthesize() {
        return this.getParent() != null && !(this.getParent() instanceof QueryTree);
    }

    @Override
    public CompositeItem clone() {
        CompositeItem copy = (CompositeItem)super.clone();
        copy.subitems = new ArrayList<Item>(this.subitems.size());
        for (Item subItem : this.subitems) {
            Item subItemCopy = subItem.clone();
            subItemCopy.setParent(copy);
            copy.subitems.add(subItemCopy);
        }
        this.fixConnexity(copy);
        return copy;
    }

    private void fixConnexity(CompositeItem copy) {
        int hasUniqueIdCount = CompositeItem.countUniqueId(this);
        if (hasUniqueIdCount == 0) {
            return;
        }
        ArrayList<Item> flat = new ArrayList<Item>(hasUniqueIdCount);
        ArrayList<Item> flatCopy = new ArrayList<Item>(hasUniqueIdCount);
        CompositeItem.taggingFlatten(this, flat);
        CompositeItem.taggingFlatten(copy, flatCopy);
        int barrier = flat.size();
        for (int i = 0; i < barrier; ++i) {
            Item orig = (Item)flat.get(i);
            int connectedTo = CompositeItem.find(orig.connectedItem, flat);
            if (connectedTo < 0) continue;
            TaggableItem tagged = (TaggableItem)flatCopy.get(i);
            tagged.setConnectivity((Item)flatCopy.get(connectedTo), orig.connectivity);
        }
    }

    private static int countUniqueId(Item tree) {
        int sum;
        int n = sum = tree.hasUniqueID() ? 1 : 0;
        if (tree instanceof CompositeItem) {
            CompositeItem asComposite = (CompositeItem)tree;
            ListIterator<Item> i = asComposite.getItemIterator();
            while (i.hasNext()) {
                sum += CompositeItem.countUniqueId((Item)i.next());
            }
        }
        return sum;
    }

    private static void taggingFlatten(Item tree, List<Item> container) {
        if (tree.hasUniqueID()) {
            container.add(tree);
        }
        if (tree instanceof CompositeItem) {
            CompositeItem asComposite = (CompositeItem)tree;
            ListIterator<Item> i = asComposite.getItemIterator();
            while (i.hasNext()) {
                CompositeItem.taggingFlatten((Item)i.next(), container);
            }
        }
    }

    private static int find(Item needle, List<Item> haystack) {
        if (needle == null) {
            return -1;
        }
        int barrier = haystack.size();
        for (int i = 0; i < barrier; ++i) {
            if (haystack.get(i) != needle) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        int code = this.getName().hashCode() + this.subitems.size() * 17;
        for (int i = 0; i < this.subitems.size() && i <= 5; ++i) {
            code += this.subitems.get(i).hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        CompositeItem other = (CompositeItem)object;
        return this.subitems.equals(other.subitems);
    }

    public void lock() {
    }

    public boolean isLocked() {
        return false;
    }

    @Override
    public int getTermCount() {
        int terms = 0;
        for (Item item : this.subitems) {
            terms += item.getTermCount();
        }
        return terms;
    }

    public Optional<Item> extractSingleChild() {
        return this.getItemCount() == 1 ? Optional.of(this.getItem(0)) : Optional.empty();
    }

    public boolean acceptsItemsOfType(Item.ItemType itemType) {
        return true;
    }

    private static class ListIteratorWrapper
    implements ListIterator<Item> {
        private final CompositeItem owner;
        private final ListIterator<Item> wrapped;
        private Item current = null;

        public ListIteratorWrapper(CompositeItem owner) {
            this.owner = owner;
            this.wrapped = owner.subitems.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public Item next() {
            this.current = this.wrapped.next();
            return this.current;
        }

        @Override
        public boolean hasPrevious() {
            return this.wrapped.hasPrevious();
        }

        @Override
        public Item previous() {
            this.current = this.wrapped.previous();
            return this.current;
        }

        @Override
        public int nextIndex() {
            return this.wrapped.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.wrapped.previousIndex();
        }

        @Override
        public void remove() {
            this.wrapped.remove();
            this.owner.removing(this.current);
        }

        @Override
        public void set(Item newItem) {
            if (newItem == this.current) {
                return;
            }
            this.owner.removing(this.current);
            this.owner.adding(newItem);
            this.current = newItem;
            this.wrapped.set(newItem);
        }

        @Override
        public void add(Item newItem) {
            this.owner.adding(newItem);
            this.wrapped.add(newItem);
        }
    }
}

