/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.textserialize.serializer;

import com.yahoo.search.query.textserialize.serializer.ItemIdMapper;
import com.yahoo.search.query.textserialize.serializer.Serializer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DispatchForm {
    private final String name;
    public final Map<Object, Object> properties = new LinkedHashMap<Object, Object>();
    public final List<Object> children = new ArrayList<Object>();

    public DispatchForm(String name) {
        this.name = name;
    }

    public void addChild(Object child) {
        this.children.add(child);
    }

    public String serialize(ItemIdMapper itemIdMapper) {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(this.name);
        this.serializeProperties(builder, itemIdMapper);
        this.serializeChildren(builder, itemIdMapper);
        builder.append(')');
        return builder.toString();
    }

    private void serializeProperties(StringBuilder builder, ItemIdMapper itemIdMapper) {
        if (this.properties.isEmpty()) {
            return;
        }
        builder.append(' ').append(Serializer.serializeMap(this.properties, itemIdMapper));
    }

    private void serializeChildren(StringBuilder builder, ItemIdMapper itemIdMapper) {
        for (Object child : this.children) {
            builder.append(' ').append(Serializer.serialize(child, itemIdMapper));
        }
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }
}

