/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.MultiTermItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MultiRangeItem<Type extends Number>
extends MultiTermItem {
    private final NumberType<Type> type;
    private final String startIndex;
    private final String endIndex;
    private final boolean startInclusive;
    private final boolean endInclusive;
    private List<Range<Type>> ranges = new ArrayList<Range<Type>>();
    private boolean sorted = true;
    private NumberEncoder<Type> encoder;

    private MultiRangeItem(NumberType<Type> type, String startIndex, Limit startInclusive, String endIndex, Limit endInclusive) {
        if (startIndex.isBlank()) {
            throw new IllegalArgumentException("start index name must be non-blank");
        }
        if (endIndex.isBlank()) {
            throw new IllegalArgumentException("end index name must be non-blank");
        }
        this.type = Objects.requireNonNull(type);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.startInclusive = startInclusive == Objects.requireNonNull(Limit.INCLUSIVE);
        this.endInclusive = endInclusive == Objects.requireNonNull(Limit.INCLUSIVE);
    }

    public static <Type extends Number> MultiRangeItem<Type> overRanges(NumberType<Type> type, String startIndex, Limit startInclusive, String endIndex, Limit endInclusive) {
        return new MultiRangeItem<Type>(type, startIndex, startInclusive, endIndex, endInclusive);
    }

    public static <Type extends Number> MultiRangeItem<Type> overPoints(NumberType<Type> type, String index, Limit startInclusive, Limit endInclusive) {
        return MultiRangeItem.overRanges(type, index, startInclusive, index, endInclusive);
    }

    public MultiRangeItem<Type> addPoint(Type point) {
        return this.addRange(point, point);
    }

    public MultiRangeItem<Type> addRange(Type start, Type end) {
        if (Double.isNaN(((Number)start).doubleValue())) {
            throw new IllegalArgumentException("range start cannot be NaN");
        }
        if (Double.isNaN(((Number)end).doubleValue())) {
            throw new IllegalArgumentException("range end cannot be NaN");
        }
        if (this.type.comparator.compare(start, end) > 0) {
            throw new IllegalArgumentException("ranges must satisfy start <= end, but got " + String.valueOf(start) + " > " + String.valueOf(end));
        }
        Range<Type> range = new Range<Type>(start, end);
        if (this.sorted && !this.ranges.isEmpty()) {
            Range<Type> last = this.ranges.get(this.ranges.size() - 1);
            this.sorted = this.overlap(range, last);
            if (this.sorted) {
                Range<Type> popped = range;
                int i = this.ranges.size();
                while (i-- > 0 && this.overlap(this.ranges.get(i), range)) {
                    popped = this.ranges.remove(i);
                }
                this.ranges.add(popped == range ? range : new Range<Type>(this.min(popped.start, range.start), this.max(last.end, range.end)));
                return this;
            }
        }
        this.ranges.add(range);
        return this;
    }

    private boolean overlap(Range<Type> first, Range<Type> second) {
        int comparison = this.type.comparator.compare(first.end, second.start);
        return comparison > 0 || comparison == 0 && (this.startInclusive || this.endInclusive || first.start.equals(first.end) || second.start.equals(second.end));
    }

    private Type min(Type a, Type b) {
        return this.type.comparator.compare(a, b) <= 0 ? a : b;
    }

    private Type max(Type a, Type b) {
        return this.type.comparator.compare(a, b) >= 0 ? a : b;
    }

    List<Range<Type>> sortedRanges() {
        Range start;
        if (this.sorted) {
            return this.ranges;
        }
        this.ranges.sort((r1, r2) -> this.type.comparator.compare(r1.start, r2.start));
        ArrayList<Range<Type>> pruned = new ArrayList<Range<Type>>();
        Range end = start = this.ranges.get(0);
        for (int i = 1; i < this.ranges.size(); ++i) {
            Range range = this.ranges.get(i);
            if (this.overlap(end, range)) {
                end = this.type.comparator.compare(end.end, range.end) < 0 ? range : end;
                continue;
            }
            pruned.add(start == end ? start : new Range(start.start, end.end));
            start = end = range;
        }
        pruned.add(start == end ? start : new Range(start.start, end.end));
        this.sorted = true;
        this.ranges = pruned;
        return this.ranges;
    }

    @Override
    public void setIndexName(String index) {
        throw new UnsupportedOperationException("index cannot be changed for " + MultiRangeItem.class.getSimpleName());
    }

    @Override
    MultiTermItem.OperatorType operatorType() {
        return MultiTermItem.OperatorType.OR;
    }

    @Override
    MultiTermItem.TermType termType() {
        return MultiTermItem.TermType.RANGES;
    }

    @Override
    int terms() {
        return this.sortedRanges().size();
    }

    @Override
    void encodeBlueprint(ByteBuffer buffer) {
        boolean sameIndex = this.startIndex.equals(this.endIndex);
        byte metadata = 0;
        if (sameIndex) {
            metadata = (byte)(metadata | 1);
        }
        if (this.startInclusive) {
            metadata = (byte)(metadata | 2);
        }
        if (this.endInclusive) {
            metadata = (byte)(metadata | 4);
        }
        this.encoder = this.type.encoderFor(this.sortedRanges());
        metadata = (byte)(metadata | (byte)(this.encoder.id << 3));
        buffer.put(metadata);
        MultiRangeItem.putString(this.startIndex, buffer);
        if (!sameIndex) {
            MultiRangeItem.putString(this.endIndex, buffer);
        }
    }

    @Override
    void encodeTerms(ByteBuffer buffer) {
        for (Range<Type> range : this.sortedRanges()) {
            this.encoder.serializer.accept(buffer, range.start);
            this.encoder.serializer.accept(buffer, range.end);
        }
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        this.asCompositeItem().appendBodyString(buffer);
    }

    @Override
    public void disclose(Discloser discloser) {
        this.asCompositeItem().disclose(discloser);
    }

    @Override
    public Item clone() {
        MultiRangeItem clone = (MultiRangeItem)super.clone();
        clone.ranges = new ArrayList<Range<Type>>(this.ranges);
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiRangeItem that = (MultiRangeItem)o;
        return this.type == that.type && this.startInclusive == that.startInclusive && this.endInclusive == that.endInclusive && this.startIndex.equals(that.startIndex) && this.endIndex.equals(that.endIndex) && this.sortedRanges().equals(that.sortedRanges());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type, this.startIndex, this.endIndex, this.startInclusive, this.endInclusive, this.sortedRanges());
    }

    @Override
    Item asCompositeItem() {
        OrItem root = new OrItem();
        if (this.startIndex.equals(this.endIndex)) {
            for (Range<Type> range : this.sortedRanges()) {
                root.addItem(new IntItem(new com.yahoo.prelude.query.Limit((Number)range.start, this.startInclusive), new com.yahoo.prelude.query.Limit((Number)range.end, this.endInclusive), this.startIndex));
            }
        } else {
            for (Range<Type> range : this.sortedRanges()) {
                AndItem pair = new AndItem();
                pair.addItem(new IntItem(new com.yahoo.prelude.query.Limit((Number)range.start, this.startInclusive), com.yahoo.prelude.query.Limit.POSITIVE_INFINITY, this.startIndex));
                pair.addItem(new IntItem(com.yahoo.prelude.query.Limit.NEGATIVE_INFINITY, new com.yahoo.prelude.query.Limit((Number)range.end, this.endInclusive), this.endIndex));
                root.addItem(pair);
            }
        }
        return root;
    }

    public static class NumberType<Type extends Number> {
        public static final NumberType<Integer> INTEGER = new NumberType((a, b) -> a < b ? -1 : (a > b ? 1 : 0), ranges -> switch (IntegerCompressor.compressionMode((int)((Integer)((Range)ranges.get((int)0)).start), (int)((Integer)((Range)ranges.get((int)(ranges.size() - 1))).end))) {
            default -> throw new IncompatibleClassChangeError();
            case IntegerCompressor.Mode.NONE -> NumberEncoder.UNIFORM_INTEGER;
            case IntegerCompressor.Mode.COMPRESSED -> NumberEncoder.COMPRESSED_INTEGER;
            case IntegerCompressor.Mode.COMPRESSED_POSITIVE -> NumberEncoder.COMPRESSED_POSITIVE_INTEGER;
        });
        public static final NumberType<Long> LONG = new NumberType((a, b) -> a < b ? -1 : (a > b ? 1 : 0), __ -> NumberEncoder.UNIFORM_LONG);
        public static final NumberType<Double> DOUBLE = new NumberType((a, b) -> a < b ? -1 : (a > b ? 1 : 0), __ -> NumberEncoder.UNIFORM_DOUBLE);
        private final Comparator<Type> comparator;
        private final Function<List<Range<Type>>, NumberEncoder<Type>> encoder;

        private NumberType(Comparator<Type> comparator, Function<List<Range<Type>>, NumberEncoder<Type>> encoder) {
            this.comparator = comparator;
            this.encoder = encoder;
        }

        NumberEncoder<Type> encoderFor(List<Range<Type>> ranges) {
            return this.encoder.apply(ranges);
        }
    }

    public static enum Limit {
        INCLUSIVE,
        EXCLUSIVE;

    }

    static class Range<Type extends Number> {
        final Type start;
        final Type end;

        Range(Type start, Type end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.start.equals(range.start) && this.end.equals(range.end);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public String toString() {
            return "(" + String.valueOf(this.start) + ", " + String.valueOf(this.end) + ")";
        }
    }

    private static class NumberEncoder<Type extends Number> {
        static NumberEncoder<Integer> UNIFORM_INTEGER = new NumberEncoder<Integer>(0, ByteBuffer::putInt);
        static NumberEncoder<Long> UNIFORM_LONG = new NumberEncoder<Long>(1, ByteBuffer::putLong);
        static NumberEncoder<Double> UNIFORM_DOUBLE = new NumberEncoder<Double>(2, ByteBuffer::putDouble);
        static NumberEncoder<Integer> COMPRESSED_INTEGER = new NumberEncoder<Integer>(3, (b, n) -> IntegerCompressor.putCompressedNumber((int)n, (ByteBuffer)b));
        static NumberEncoder<Integer> COMPRESSED_POSITIVE_INTEGER = new NumberEncoder<Integer>(4, (b, n) -> IntegerCompressor.putCompressedPositiveNumber((int)n, (ByteBuffer)b));
        final byte id;
        final BiConsumer<ByteBuffer, Type> serializer;

        NumberEncoder(int id, BiConsumer<ByteBuffer, Type> serializer) {
            this.id = (byte)id;
            this.serializer = serializer;
        }
    }
}

