/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import com.yahoo.text.Utf8;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class MapEncoder {
    private static byte[] getUtf8(Object value) {
        if (value == null) {
            return Utf8.toBytes((String)"");
        }
        if (value instanceof Tensor) {
            return TypedBinaryFormat.encode((Tensor)((Tensor)value));
        }
        return Utf8.toBytes((String)value.toString());
    }

    public static int encodeSingleValue(String mapName, String key, Object value, ByteBuffer buffer) {
        if (value == null) {
            return 0;
        }
        byte[] utf8 = Utf8.toBytes((String)mapName);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        buffer.putInt(1);
        utf8 = Utf8.toBytes((String)key);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        utf8 = MapEncoder.getUtf8(value);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        return 1;
    }

    public static int encodeMap(String mapName, Map<String, ?> map, ByteBuffer buffer) {
        if (map.isEmpty()) {
            return 0;
        }
        byte[] utf8 = Utf8.toBytes((String)mapName);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        buffer.putInt(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            utf8 = Utf8.toBytes((String)key);
            buffer.putInt(utf8.length);
            buffer.put(utf8);
            Object value = entry.getValue();
            utf8 = MapEncoder.getUtf8(value);
            buffer.putInt(utf8.length);
            buffer.put(utf8);
        }
        return 1;
    }

    public static <T> int encodeMultiMap(String mapName, Map<String, List<T>> map, ByteBuffer buffer) {
        if (map.isEmpty()) {
            return 0;
        }
        byte[] utf8 = Utf8.toBytes((String)mapName);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        buffer.putInt(MapEncoder.countEntries(map));
        for (Map.Entry<String, List<T>> property : map.entrySet()) {
            String key = property.getKey();
            for (T value : property.getValue()) {
                utf8 = Utf8.toBytes((String)key);
                buffer.putInt(utf8.length);
                buffer.put(utf8);
                utf8 = MapEncoder.getUtf8(value);
                buffer.putInt(utf8.length);
                buffer.put(utf8);
            }
        }
        return 1;
    }

    private static <T> int countEntries(Map<String, List<T>> value) {
        int entries = 0;
        for (Map.Entry<String, List<T>> property : value.entrySet()) {
            entries += property.getValue().size();
        }
        return entries;
    }
}

