/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.shared;

import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.messagebus.DestinationSession;
import com.yahoo.messagebus.DestinationSessionParams;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.shared.ServerSession;
import com.yahoo.messagebus.shared.SharedMessageBus;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedDestinationSession
extends AbstractResource
implements MessageHandler,
ServerSession {
    private static final Logger log = Logger.getLogger(SharedDestinationSession.class.getName());
    private final AtomicReference<MessageHandler> msgHandler = new AtomicReference();
    private final DestinationSession session;
    private final ResourceReference mbusReference;

    SharedDestinationSession(SharedMessageBus mbus, DestinationSessionParams params) {
        this.msgHandler.set(params.getMessageHandler());
        this.session = mbus.messageBus().createDetachedDestinationSession(params.setMessageHandler((MessageHandler)this));
        this.mbusReference = mbus.refer(this);
    }

    public DestinationSession session() {
        return this.session;
    }

    @Override
    public void sendReply(Reply reply) {
        this.session.reply(reply);
    }

    @Override
    public MessageHandler getMessageHandler() {
        return this.msgHandler.get();
    }

    @Override
    public void setMessageHandler(MessageHandler msgHandler) {
        if (!this.msgHandler.compareAndSet(null, msgHandler)) {
            throw new IllegalStateException("Message handler already registered.");
        }
    }

    public void handleMessage(Message msg) {
        MessageHandler msgHandler = this.msgHandler.get();
        if (msgHandler == null) {
            EmptyReply reply = new EmptyReply();
            reply.swapState((Routable)msg);
            reply.addError(new Error(100005, "Session not fully configured yet."));
            this.sendReply((Reply)reply);
            return;
        }
        msgHandler.handleMessage(msg);
    }

    @Override
    public String connectionSpec() {
        return this.session.getConnectionSpec();
    }

    @Override
    public String name() {
        return this.session.getName();
    }

    public void connect() {
        this.session.connect();
    }

    public void disconnect() {
        this.session.disconnect();
    }

    protected void destroy() {
        log.log(Level.FINE, "Destroying shared destination session.");
        this.session.destroy();
        this.mbusReference.close();
    }
}

