/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class SummaryConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "50b4b5e9c6a944cc3bf54be8a21ac67e";
    public static final String CONFIG_DEF_NAME = "summary";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "defaultsummaryid int default=-1", "usev8geopositions bool default=false", "classes[].id int", "classes[].name string", "classes[].omitsummaryfeatures bool default=false", "classes[].fields[].name string", "classes[].fields[].command string default=\"\"", "classes[].fields[].source string default=\"\"", "classes[].fields[].elements.select enum { ALL, BY_MATCH, BY_SUMMARY_FEATURE } default=ALL", "classes[].fields[].elements.summary_feature string default=\"\""};
    private final IntegerNode defaultsummaryid;
    private final BooleanNode usev8geopositions;
    private final InnerNodeVector<Classes> classes;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public SummaryConfig(Builder builder) {
        this(builder, true);
    }

    private SummaryConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for summary must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.defaultsummaryid = builder.defaultsummaryid == null ? new IntegerNode(-1) : new IntegerNode(builder.defaultsummaryid.intValue());
        this.usev8geopositions = builder.usev8geopositions == null ? new BooleanNode(false) : new BooleanNode(builder.usev8geopositions.booleanValue());
        this.classes = Classes.createVector(builder.classes);
    }

    public int defaultsummaryid() {
        return this.defaultsummaryid.value();
    }

    public boolean usev8geopositions() {
        return this.usev8geopositions.value();
    }

    public List<Classes> classes() {
        return this.classes;
    }

    public Classes classes(int i) {
        return (Classes)((Object)this.classes.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SummaryConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer defaultsummaryid = null;
        private Boolean usev8geopositions = null;
        public List<Classes.Builder> classes = new ArrayList<Classes.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SummaryConfig config) {
            this.defaultsummaryid(config.defaultsummaryid());
            this.usev8geopositions(config.usev8geopositions());
            for (Classes c : config.classes()) {
                this.classes(new Classes.Builder(c));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.defaultsummaryid != null) {
                this.defaultsummaryid(__superior.defaultsummaryid);
            }
            if (__superior.usev8geopositions != null) {
                this.usev8geopositions(__superior.usev8geopositions);
            }
            if (!__superior.classes.isEmpty()) {
                this.classes.addAll(__superior.classes);
            }
            return this;
        }

        public Builder defaultsummaryid(int __value) {
            this.defaultsummaryid = __value;
            return this;
        }

        private Builder defaultsummaryid(String __value) {
            return this.defaultsummaryid(Integer.valueOf(__value));
        }

        public Builder usev8geopositions(boolean __value) {
            this.usev8geopositions = __value;
            return this;
        }

        private Builder usev8geopositions(String __value) {
            return this.usev8geopositions(Boolean.valueOf(__value));
        }

        public Builder classes(Classes.Builder __builder) {
            this.classes.add(__builder);
            return this;
        }

        public Builder classes(Consumer<Classes.Builder> __func) {
            Classes.Builder __inner = new Classes.Builder();
            __func.accept(__inner);
            this.classes.add(__inner);
            return this;
        }

        public Builder classes(List<Classes.Builder> __builders) {
            this.classes = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SummaryConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SummaryConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SummaryConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SummaryConfig build() {
            return new SummaryConfig(this);
        }
    }

    public static final class Classes
    extends InnerNode {
        private final IntegerNode id;
        private final StringNode name;
        private final BooleanNode omitsummaryfeatures;
        private final InnerNodeVector<Fields> fields;

        public Classes(Builder builder) {
            this(builder, true);
        }

        private Classes(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for summary.classes[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.omitsummaryfeatures = builder.omitsummaryfeatures == null ? new BooleanNode(false) : new BooleanNode(builder.omitsummaryfeatures.booleanValue());
            this.fields = Fields.createVector(builder.fields);
        }

        public int id() {
            return this.id.value();
        }

        public String name() {
            return this.name.value();
        }

        public boolean omitsummaryfeatures() {
            return this.omitsummaryfeatures.value();
        }

        public List<Fields> fields() {
            return this.fields;
        }

        public Fields fields(int i) {
            return (Fields)((Object)this.fields.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Classes newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("classes");
            return changes;
        }

        private static InnerNodeVector<Classes> createVector(List<Builder> builders) {
            ArrayList<Classes> elems = new ArrayList<Classes>();
            for (Builder b : builders) {
                elems.add(new Classes(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("id", "name"));
            private Integer id = null;
            private String name = null;
            private Boolean omitsummaryfeatures = null;
            public List<Fields.Builder> fields = new ArrayList<Fields.Builder>();

            public Builder() {
            }

            public Builder(Classes config) {
                this.id(config.id());
                this.name(config.name());
                this.omitsummaryfeatures(config.omitsummaryfeatures());
                for (Fields f : config.fields()) {
                    this.fields(new Fields.Builder(f));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.omitsummaryfeatures != null) {
                    this.omitsummaryfeatures(__superior.omitsummaryfeatures);
                }
                if (!__superior.fields.isEmpty()) {
                    this.fields.addAll(__superior.fields);
                }
                return this;
            }

            public Builder id(int __value) {
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            private Builder id(String __value) {
                return this.id(Integer.valueOf(__value));
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder omitsummaryfeatures(boolean __value) {
                this.omitsummaryfeatures = __value;
                return this;
            }

            private Builder omitsummaryfeatures(String __value) {
                return this.omitsummaryfeatures(Boolean.valueOf(__value));
            }

            public Builder fields(Fields.Builder __builder) {
                this.fields.add(__builder);
                return this;
            }

            public Builder fields(Consumer<Fields.Builder> __func) {
                Fields.Builder __inner = new Fields.Builder();
                __func.accept(__inner);
                this.fields.add(__inner);
                return this;
            }

            public Builder fields(List<Fields.Builder> __builders) {
                this.fields = __builders;
                return this;
            }

            public Classes build() {
                return new Classes(this);
            }
        }

        public static final class Fields
        extends InnerNode {
            private final StringNode name;
            private final StringNode command;
            private final StringNode source;
            private final Elements elements;

            public Fields(Builder builder) {
                this(builder, true);
            }

            private Fields(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for summary.classes[].fields[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.command = builder.command == null ? new StringNode("") : new StringNode(builder.command);
                this.source = builder.source == null ? new StringNode("") : new StringNode(builder.source);
                this.elements = new Elements(builder.elements, throwIfUninitialized);
            }

            public String name() {
                return this.name.value();
            }

            public String command() {
                return this.command.value();
            }

            public String source() {
                return this.source.value();
            }

            public Elements elements() {
                return this.elements;
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Fields newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("fields");
                return changes;
            }

            private static InnerNodeVector<Fields> createVector(List<Builder> builders) {
                ArrayList<Fields> elems = new ArrayList<Fields>();
                for (Builder b : builders) {
                    elems.add(new Fields(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                private String name = null;
                private String command = null;
                private String source = null;
                public Elements.Builder elements = new Elements.Builder();

                public Builder() {
                }

                public Builder(Fields config) {
                    this.name(config.name());
                    this.command(config.command());
                    this.source(config.source());
                    this.elements(new Elements.Builder(config.elements()));
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.command != null) {
                        this.command(__superior.command);
                    }
                    if (__superior.source != null) {
                        this.source(__superior.source);
                    }
                    this.elements(this.elements.override(__superior.elements));
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder command(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.command = __value;
                    return this;
                }

                public Builder source(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.source = __value;
                    return this;
                }

                public Builder elements(Elements.Builder __builder) {
                    this.elements = __builder;
                    return this;
                }

                public Builder elements(Consumer<Elements.Builder> __func) {
                    Elements.Builder __inner = new Elements.Builder();
                    __func.accept(__inner);
                    this.elements = __inner;
                    return this;
                }

                public Fields build() {
                    return new Fields(this);
                }
            }

            public static final class Elements
            extends InnerNode {
                private final Select select;
                private final StringNode summary_feature;

                public Elements(Builder builder) {
                    this(builder, true);
                }

                private Elements(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for summary.classes[].fields[].elements must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.select = builder.select == null ? new Select(Select.ALL) : new Select(builder.select);
                    this.summary_feature = builder.summary_feature == null ? new StringNode("") : new StringNode(builder.summary_feature);
                }

                public Select.Enum select() {
                    return (Select.Enum)((Object)this.select.value());
                }

                public String summary_feature() {
                    return this.summary_feature.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Elements newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("elements");
                    return changes;
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private Select.Enum select = null;
                    private String summary_feature = null;

                    public Builder() {
                    }

                    public Builder(Elements config) {
                        this.select(config.select());
                        this.summary_feature(config.summary_feature());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.select != null) {
                            this.select(__superior.select);
                        }
                        if (__superior.summary_feature != null) {
                            this.summary_feature(__superior.summary_feature);
                        }
                        return this;
                    }

                    public Builder select(Select.Enum __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.select = __value;
                        return this;
                    }

                    private Builder select(String __value) {
                        return this.select(Select.Enum.valueOf(__value));
                    }

                    public Builder summary_feature(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.summary_feature = __value;
                        return this;
                    }

                    public Elements build() {
                        return new Elements(this);
                    }
                }

                public static final class Select
                extends EnumNode<Enum> {
                    public static final Enum ALL = Enum.ALL;
                    public static final Enum BY_MATCH = Enum.BY_MATCH;
                    public static final Enum BY_SUMMARY_FEATURE = Enum.BY_SUMMARY_FEATURE;

                    public Select() {
                        this.value = null;
                    }

                    public Select(Enum enumValue) {
                        super(enumValue != null);
                        this.value = enumValue;
                    }

                    protected boolean doSetValue(String name) {
                        try {
                            this.value = Enum.valueOf(name);
                            return true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return false;
                        }
                    }

                    public static enum Enum {
                        ALL,
                        BY_MATCH,
                        BY_SUMMARY_FEATURE;

                    }
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

