/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.WireguardKey;
import com.yahoo.jdisc.Timer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Random;

public record WireguardKeyWithTimestamp(WireguardKey key, Instant timestamp) {
    public static final int KEY_ROTATION_BASE = 60;
    public static final int KEY_ROTATION_VARIANCE = 10;
    public static final int KEY_EXPIRY = 75;

    public WireguardKeyWithTimestamp {
        if (key == null) {
            throw new IllegalArgumentException("Wireguard key cannot be null");
        }
        if (timestamp == null) {
            timestamp = Instant.EPOCH;
        }
    }

    public static WireguardKeyWithTimestamp from(String key, long msTimestamp) {
        return new WireguardKeyWithTimestamp(WireguardKey.from(key), Instant.ofEpochMilli(msTimestamp));
    }

    public boolean isDueForRotation(Timer timer, ChronoUnit unit, Random random) {
        return timer.currentTime().isAfter(this.keyRotationDueAt(unit, random));
    }

    public boolean hasExpired(Timer timer, ChronoUnit unit) {
        return timer.currentTime().isAfter(this.timestamp.plus(75L, unit));
    }

    private Instant keyRotationDueAt(ChronoUnit unit, Random random) {
        return this.timestamp.plus((long)(60 + random.nextInt(10)), unit);
    }
}

