/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.config.content.FleetcontrollerConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import java.util.Optional;

public class ResourceLimits
implements FleetcontrollerConfig.Producer,
ProtonConfig.Producer {
    private final Optional<Double> diskLimit;
    private final Optional<Double> memoryLimit;
    private final Optional<Double> addressSpaceLimit;

    private ResourceLimits(Builder builder) {
        this.diskLimit = builder.diskLimit;
        this.memoryLimit = builder.memoryLimit;
        this.addressSpaceLimit = builder.addressSpaceLimit;
    }

    public Optional<Double> getDiskLimit() {
        return this.diskLimit;
    }

    public Optional<Double> getMemoryLimit() {
        return this.memoryLimit;
    }

    public Optional<Double> getAddressSpaceLimit() {
        return this.addressSpaceLimit;
    }

    public void getConfig(FleetcontrollerConfig.Builder builder) {
        builder.cluster_feed_block_limit.put("memory", this.memoryLimit.orElse(0.8));
        builder.cluster_feed_block_limit.put("disk", this.diskLimit.orElse(0.75));
        builder.cluster_feed_block_limit.put("attribute-address-space", this.addressSpaceLimit.orElse(0.8));
    }

    public void getConfig(ProtonConfig.Builder builder) {
        this.diskLimit.ifPresent(d -> builder.writefilter.disklimit(d.doubleValue()));
        this.memoryLimit.ifPresent(d -> builder.writefilter.memorylimit(d.doubleValue()));
    }

    public static class Builder {
        private Optional<Double> diskLimit = Optional.empty();
        private Optional<Double> memoryLimit = Optional.empty();
        private Optional<Double> addressSpaceLimit = Optional.empty();

        public ResourceLimits build() {
            return new ResourceLimits(this);
        }

        public Optional<Double> getDiskLimit() {
            return this.diskLimit;
        }

        public Builder setDiskLimit(double diskLimit) {
            this.diskLimit = Optional.of(diskLimit);
            return this;
        }

        public Optional<Double> getMemoryLimit() {
            return this.memoryLimit;
        }

        public Builder setMemoryLimit(double memoryLimit) {
            this.memoryLimit = Optional.of(memoryLimit);
            return this;
        }

        public Optional<Double> getAddressSpaceLimit() {
            return this.addressSpaceLimit;
        }

        public Builder setAddressSpaceLimit(double addressSpaceLimit) {
            this.addressSpaceLimit = Optional.of(addressSpaceLimit);
            return this;
        }
    }
}

