/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.config.content.StorDistributionConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;

public class Redundancy
implements StorDistributionConfig.Producer,
ProtonConfig.Producer {
    private final int initialRedundancy;
    private final int finalRedundancy;
    private final int readyCopies;
    private final int groups;
    private final int totalNodes;

    public Redundancy(Integer initialRedundancy, int finalRedundancy, int readyCopies, int groups, int totalNodes) {
        if (readyCopies > finalRedundancy) {
            throw new IllegalArgumentException("Number of searchable copies (" + readyCopies + ") can not be higher than final redundancy (" + finalRedundancy + ")");
        }
        this.initialRedundancy = initialRedundancy != null ? initialRedundancy : finalRedundancy;
        this.finalRedundancy = finalRedundancy;
        this.readyCopies = readyCopies;
        this.groups = groups;
        this.totalNodes = totalNodes;
    }

    public int finalRedundancy() {
        return (int)Math.ceil((double)this.effectiveFinalRedundancy() / (double)this.groups);
    }

    public int readyCopies() {
        return (int)Math.ceil((double)this.effectiveReadyCopies() / (double)this.groups);
    }

    public int groups() {
        return this.groups;
    }

    public int totalNodes() {
        return this.totalNodes;
    }

    public int effectiveInitialRedundancy() {
        return Math.min(this.totalNodes, this.initialRedundancy * this.groups);
    }

    public int effectiveFinalRedundancy() {
        return Math.min(this.totalNodes, this.finalRedundancy * this.groups);
    }

    public int effectiveReadyCopies() {
        return Math.min(this.totalNodes, this.readyCopies * this.groups);
    }

    public boolean isEffectivelyGloballyDistributed() {
        return this.totalNodes == this.effectiveFinalRedundancy();
    }

    public void getConfig(StorDistributionConfig.Builder builder) {
        builder.initial_redundancy(this.effectiveInitialRedundancy());
        builder.redundancy(this.effectiveFinalRedundancy());
        builder.ready_copies(this.effectiveReadyCopies());
    }

    public void getConfig(ProtonConfig.Builder builder) {
        ProtonConfig.Distribution.Builder distBuilder = new ProtonConfig.Distribution.Builder();
        distBuilder.redundancy((long)this.finalRedundancy());
        distBuilder.searchablecopies((long)this.readyCopies());
        builder.distribution(distBuilder);
    }

    public static interface Provider {
        public Redundancy redundancy();
    }
}

