/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component.chain;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Phase;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.vespa.model.container.component.chain.Chain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class ChainsConfigGenerator<T extends Chain> {
    ChainsConfigGenerator() {
    }

    public static <T extends Chain> void generate(ChainsConfig.Builder builder, Collection<T> chains) {
        for (Chain chain : chains) {
            builder.chains(ChainsConfigGenerator.getChain(chain));
        }
    }

    private static <T extends Chain> ChainsConfig.Chains.Builder getChain(T chain) {
        ChainSpecification specification = chain.getChainSpecification();
        return new ChainsConfig.Chains.Builder().type(chain.getType()).id(specification.componentId.stringValue()).components(ChainsConfigGenerator.getComponents(specification.componentReferences)).inherits(ChainsConfigGenerator.getComponents(specification.inheritance.chainSpecifications)).excludes(ChainsConfigGenerator.getComponents(specification.inheritance.excludedComponents)).phases(ChainsConfigGenerator.getPhases(specification.phases()));
    }

    private static List<String> getComponents(Collection<ComponentSpecification> componentSpecs) {
        ArrayList<String> components = new ArrayList<String>();
        for (ComponentSpecification spec : componentSpecs) {
            components.add(spec.stringValue());
        }
        return components;
    }

    private static List<ChainsConfig.Chains.Phases.Builder> getPhases(Collection<Phase> phases) {
        ArrayList<ChainsConfig.Chains.Phases.Builder> builders = new ArrayList<ChainsConfig.Chains.Phases.Builder>();
        for (Phase phase : phases) {
            builders.add(new ChainsConfig.Chains.Phases.Builder().id(phase.getName()).before((Collection)phase.before()).after((Collection)phase.after()));
        }
        return builders;
    }
}

