/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import ai.vespa.modelintegration.evaluator.config.OnnxEvaluatorConfig;
import com.yahoo.config.model.api.OnnxModelOptions;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.component.TypedComponent;
import com.yahoo.vespa.model.utils.Duration;
import java.util.Optional;
import org.w3c.dom.Element;

abstract class OnnxEmbedder
extends TypedComponent
implements OnnxEvaluatorConfig.Producer {
    protected final OnnxModelOptions onnxModelOptions;

    protected OnnxEmbedder(String className, String bundle, Element xml, DeployState state) {
        super(className, bundle, xml);
        Element concurrencyElement;
        OnnxModelOptions opts = OnnxModelOptions.empty();
        opts = XML.getChildValue((Element)xml, (String)"onnx-execution-mode").map(arg_0 -> ((OnnxModelOptions)opts).withExecutionMode(arg_0)).orElse(opts);
        opts = XML.getChildValue((Element)xml, (String)"onnx-interop-threads").map(Integer::parseInt).map(arg_0 -> ((OnnxModelOptions)opts).withInterOpThreads(arg_0)).orElse(opts);
        opts = XML.getChildValue((Element)xml, (String)"onnx-intraop-threads").map(Integer::parseInt).map(arg_0 -> ((OnnxModelOptions)opts).withIntraOpThreads(arg_0)).orElse(opts);
        opts = XML.getChildValue((Element)xml, (String)"onnx-gpu-device").map(Integer::parseInt).map(OnnxModelOptions.GpuDevice::new).map(arg_0 -> ((OnnxModelOptions)opts).withGpuDevice(arg_0)).orElse(opts);
        Element batchingElement = XML.getChild((Element)xml, (String)"batching");
        if (batchingElement != null) {
            opts = XML.attribute((String)"max-size", (Element)batchingElement).map(value -> {
                try {
                    return Integer.parseUnsignedInt(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Batching max-size should be a positive integer, provided: " + value, e);
                }
            }).map(arg_0 -> ((OnnxModelOptions)opts).withBatchingMaxSize(arg_0)).orElse(opts);
            opts = XML.attribute((String)"max-delay", (Element)batchingElement).map(OnnxEmbedder::parseMillis).map(arg_0 -> ((OnnxModelOptions)opts).withBatchingMaxDelay(arg_0)).orElse(opts);
        }
        if ((concurrencyElement = XML.getChild((Element)xml, (String)"concurrency")) != null) {
            opts = XML.attribute((String)"type", (Element)concurrencyElement).map(arg_0 -> ((OnnxModelOptions)opts).withConcurrencyFactorType(arg_0)).orElse(opts);
            opts = Optional.ofNullable(concurrencyElement.getTextContent()).filter(content -> !content.isBlank()).map(Double::parseDouble).map(arg_0 -> ((OnnxModelOptions)opts).withConcurrencyFactor(arg_0)).orElse(opts);
        }
        this.onnxModelOptions = opts = XML.getChildValue((Element)xml, (String)"model-config-override").filter(value -> !value.isBlank()).map(value -> state.getFileRegistry().addFile(value)).map(arg_0 -> ((OnnxModelOptions)opts).withModelConfigOverride(arg_0)).orElse(opts);
    }

    public void getConfig(OnnxEvaluatorConfig.Builder builder) {
        this.onnxModelOptions.executionMode().ifPresent(value -> builder.executionMode(OnnxEvaluatorConfig.ExecutionMode.Enum.valueOf((String)value)));
        this.onnxModelOptions.interOpThreads().ifPresent(arg_0 -> ((OnnxEvaluatorConfig.Builder)builder).interOpThreads(arg_0));
        this.onnxModelOptions.intraOpThreads().ifPresent(arg_0 -> ((OnnxEvaluatorConfig.Builder)builder).intraOpThreads(arg_0));
        this.onnxModelOptions.gpuDevice().ifPresent(value -> builder.gpuDevice(value.deviceNumber()));
        this.onnxModelOptions.batchingMaxSize().ifPresent(arg_0 -> ((OnnxEvaluatorConfig.Batching.Builder)builder.batching).maxSize(arg_0));
        this.onnxModelOptions.batchingMaxDelay().ifPresent(delay -> builder.batching.maxDelayMillis(delay.toMillis()));
        this.onnxModelOptions.concurrencyFactorType().ifPresent(value -> builder.concurrency.factorType(OnnxEvaluatorConfig.Concurrency.FactorType.Enum.valueOf((String)value)));
        this.onnxModelOptions.concurrencyFactor().ifPresent(arg_0 -> ((OnnxEvaluatorConfig.Concurrency.Builder)builder.concurrency).factor(arg_0));
        builder.modelConfigOverride(this.onnxModelOptions.modelConfigOverride());
    }

    private static java.time.Duration parseMillis(String duration) {
        return java.time.Duration.ofMillis(new Duration(duration).getMilliSeconds());
    }
}

