/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.content.ContentSearchCluster;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class HnswValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        Set<ContentCluster> clusters = HnswValidator.clustersWithMoreThanOneSearchableCopy(context);
        if (clusters.isEmpty()) {
            return;
        }
        clusters.forEach(contentCluster -> HnswValidator.validateCluster(context, contentCluster.getSearch()));
    }

    private static void validateCluster(Validation.Context context, ContentSearchCluster cluster) {
        if (!cluster.hasSearchCluster()) {
            return;
        }
        List<String> fields = cluster.getSearchCluster().schemas().values().stream().map(HnswValidator::fieldsWithHnswIndex).filter(Optional::isPresent).map(Optional::get).toList();
        if (fields.isEmpty()) {
            return;
        }
        String message = "Cluster '%s' has searchable copies > 1 and fields with hnsw index: %s. This will use a lot of resources, consider using searchable-copies=1%s".formatted(cluster.getClusterName(), String.join((CharSequence)", ", fields), cluster.usesHierarchicDistribution() ? "" : " and going to a grouped setup, see https://docs.vespa.ai/en/elasticity.html#grouped-distribution");
        context.deployState().getDeployLogger().logApplicationPackage(Level.INFO, message);
    }

    private static Optional<String> fieldsWithHnswIndex(SchemaInfo schema) {
        List<String> fields = schema.fullSchema().allFields().filter(HnswValidator::hasHnswIndex).map(ImmutableSDField::getName).sorted().toList();
        if (fields.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of("fields %s in schema %s".formatted(String.join((CharSequence)", ", fields), schema.name()));
    }

    private static Set<ContentCluster> clustersWithMoreThanOneSearchableCopy(Validation.Context context) {
        return context.model().getContentClusters().values().stream().filter(c -> c.getRedundancy().readyCopies() > 1).collect(Collectors.toSet());
    }

    private static boolean hasHnswIndex(ImmutableSDField field) {
        return field.getAttributes().values().stream().anyMatch(a -> a.hnswIndexParams().isPresent());
    }
}

