/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.document;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public final class BooleanIndexDefinition {
    public static final int DEFAULT_ARITY = 8;
    public static final long DEFAULT_UPPER_BOUND = Long.MAX_VALUE;
    public static final long DEFAULT_LOWER_BOUND = Long.MIN_VALUE;
    public static final double DEFAULT_DENSE_POSTING_LIST_THRESHOLD = 0.4;
    private final OptionalInt arity;
    private final OptionalLong lowerBound;
    private final OptionalLong upperBound;
    private final OptionalDouble densePostingListThreshold;

    public BooleanIndexDefinition(Optional<Integer> arity, Optional<Long> lowerBound, Optional<Long> upperBound, Optional<Double> densePLT) {
        this.arity = arity.isPresent() ? OptionalInt.of(arity.get()) : OptionalInt.empty();
        this.lowerBound = lowerBound.isPresent() ? OptionalLong.of(lowerBound.get()) : OptionalLong.empty();
        this.upperBound = upperBound.isPresent() ? OptionalLong.of(upperBound.get()) : OptionalLong.empty();
        this.densePostingListThreshold = densePLT.isPresent() ? OptionalDouble.of(densePLT.get()) : OptionalDouble.empty();
    }

    public BooleanIndexDefinition(OptionalInt arity, OptionalLong lowerBound, OptionalLong upperBound, OptionalDouble densePostingListThreshold) {
        this.arity = arity;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.densePostingListThreshold = densePostingListThreshold;
    }

    public int getArity() {
        return this.arity.getAsInt();
    }

    public boolean hasArity() {
        return this.arity.isPresent();
    }

    public long getLowerBound() {
        return this.lowerBound.orElse(Long.MIN_VALUE);
    }

    public boolean hasLowerBound() {
        return this.lowerBound.isPresent();
    }

    public long getUpperBound() {
        return this.upperBound.orElse(Long.MAX_VALUE);
    }

    public boolean hasUpperBound() {
        return this.upperBound.isPresent();
    }

    public double getDensePostingListThreshold() {
        return this.densePostingListThreshold.orElse(0.4);
    }

    public boolean hasDensePostingListThreshold() {
        return this.densePostingListThreshold.isPresent();
    }

    public String toString() {
        return "BooleanIndexDefinition [arity=" + String.valueOf(this.arity) + ", lowerBound=" + String.valueOf(this.lowerBound) + ", upperBound=" + String.valueOf(this.upperBound) + ", densePostingListThreshold=" + String.valueOf(this.densePostingListThreshold) + "]";
    }
}

