/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.collections.Pair;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterInfo;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.IntRange;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.ZoneEndpoint;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodesSpecification {
    private final ClusterResources min;
    private final ClusterResources max;
    private final IntRange groupSize;
    private final boolean dedicated;
    private final Version version;
    private final boolean required;
    private final boolean canFail;
    private final boolean exclusive;
    private final Optional<DockerImage> dockerImageRepo;
    private final Optional<CloudAccount> cloudAccount;
    private final boolean hasCountAttribute;

    private NodesSpecification(ClusterResources min, ClusterResources max, IntRange groupSize, boolean dedicated, Version version, boolean required, boolean canFail, boolean exclusive, Optional<DockerImage> dockerImageRepo, Optional<CloudAccount> cloudAccount, boolean hasCountAttribute) {
        if (max.smallerThan(min)) {
            throw new IllegalArgumentException("Max resources must be larger or equal to min resources, but " + String.valueOf(max) + " is smaller than " + String.valueOf(min));
        }
        if (min.nodes() < 1) {
            throw new IllegalArgumentException("Min node count cannot be less than 1, but is " + min.nodes());
        }
        if (!min.nodeResources().justNonNumbers().equals((Object)max.nodeResources().justNonNumbers())) {
            throw new IllegalArgumentException("Min and max resources must have the same non-numeric settings, but min is " + String.valueOf(min) + " and max " + String.valueOf(max));
        }
        if (min.nodeResources().bandwidthGbps() != max.nodeResources().bandwidthGbps()) {
            throw new IllegalArgumentException("Min and max resources must have the same bandwidth, but min is " + String.valueOf(min) + " and max " + String.valueOf(max));
        }
        this.min = min;
        this.max = max;
        this.groupSize = groupSize;
        this.dedicated = dedicated;
        this.version = version;
        this.required = required;
        this.canFail = canFail;
        this.exclusive = exclusive;
        this.dockerImageRepo = dockerImageRepo;
        this.cloudAccount = cloudAccount;
        this.hasCountAttribute = hasCountAttribute;
    }

    static NodesSpecification create(boolean dedicated, boolean canFail, Version version, ModelElement nodesElement, Optional<DockerImage> dockerImageRepo, Optional<CloudAccount> cloudAccount) {
        ModelElement resolvedElement = NodesSpecification.resolveElement(nodesElement);
        ResourceConstraints resourceConstraints = NodesSpecification.toResourceConstraints(resolvedElement);
        boolean hasCountAttribute = resolvedElement.stringAttribute("count") != null;
        return new NodesSpecification(resourceConstraints.min, resourceConstraints.max, resourceConstraints.groupSize, dedicated, version, resolvedElement.booleanAttribute("required", false), canFail, resolvedElement.booleanAttribute("exclusive", false), NodesSpecification.dockerImageToUse(resolvedElement, dockerImageRepo), cloudAccount, hasCountAttribute);
    }

    private static ResourceConstraints toResourceConstraints(ModelElement nodesElement) {
        IntRange nodes = NodesSpecification.rangeFrom(nodesElement, "count");
        IntRange groups = NodesSpecification.rangeFrom(nodesElement, "groups");
        IntRange groupSize = NodesSpecification.rangeFrom(nodesElement, "group-size");
        if (nodes.from().orElse(1) < 1) {
            throw new IllegalArgumentException("Min node resources cannot be less than 1, but is " + nodes.from().getAsInt());
        }
        int defaultMinGroups = nodes.from().orElse(1) / groupSize.to().orElse(nodes.from().orElse(1));
        int defaultMaxGroups = groupSize.isEmpty() ? 1 : nodes.to().orElse(1) / groupSize.from().orElse(1);
        ClusterResources min = new ClusterResources(nodes.from().orElse(1), groups.from().orElse(defaultMinGroups), (NodeResources)NodesSpecification.nodeResources(nodesElement).getFirst());
        ClusterResources max = new ClusterResources(nodes.to().orElse(1), groups.to().orElse(defaultMaxGroups), (NodeResources)NodesSpecification.nodeResources(nodesElement).getSecond());
        return new ResourceConstraints(min, max, groupSize);
    }

    private static IntRange rangeFrom(ModelElement element, String name) {
        try {
            return IntRange.from((String)element.stringAttribute(name, ""));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal " + name + " value", e);
        }
    }

    public static NodesSpecification from(ModelElement nodesElement, ConfigModelContext context) {
        return NodesSpecification.create(true, !context.getDeployState().getProperties().isBootstrap(), context.getDeployState().getWantedNodeVespaVersion(), nodesElement, context.getDeployState().getWantedDockerImageRepo(), context.getDeployState().getProperties().cloudAccount());
    }

    public static Optional<NodesSpecification> optionalDedicatedFromParent(ModelElement parentElement, ConfigModelContext context) {
        if (parentElement == null) {
            return Optional.empty();
        }
        ModelElement nodesElement = parentElement.child("nodes");
        if (nodesElement == null) {
            return Optional.empty();
        }
        return Optional.of(NodesSpecification.create(nodesElement.booleanAttribute("dedicated", false), !context.getDeployState().getProperties().isBootstrap(), context.getDeployState().getWantedNodeVespaVersion(), nodesElement, context.getDeployState().getWantedDockerImageRepo(), context.getDeployState().getProperties().cloudAccount()));
    }

    public static NodesSpecification nonDedicated(int count, ConfigModelContext context) {
        return new NodesSpecification(new ClusterResources(count, 1, NodeResources.unspecified()), new ClusterResources(count, 1, NodeResources.unspecified()), IntRange.empty(), false, context.getDeployState().getWantedNodeVespaVersion(), false, !context.getDeployState().getProperties().isBootstrap(), false, context.getDeployState().getWantedDockerImageRepo(), context.getDeployState().getProperties().cloudAccount(), false);
    }

    public static NodesSpecification dedicated(int count, ConfigModelContext context) {
        return new NodesSpecification(new ClusterResources(count, 1, NodeResources.unspecified()), new ClusterResources(count, 1, NodeResources.unspecified()), IntRange.empty(), true, context.getDeployState().getWantedNodeVespaVersion(), false, !context.getDeployState().getProperties().isBootstrap(), false, context.getDeployState().getWantedDockerImageRepo(), context.getDeployState().getProperties().cloudAccount(), false);
    }

    public static NodesSpecification requiredFromSharedParents(int count, NodeResources resources, ModelElement element, ConfigModelContext context) {
        List<NodesSpecification> allContent = NodesSpecification.findParentByTag("services", element.getXml()).map(services -> XML.getChildren((Element)services, (String)"content")).orElse(List.of()).stream().map(content -> new ModelElement((Element)content).child("nodes")).filter(nodes -> nodes != null && nodes.stringAttribute("count") != null).map(nodes -> NodesSpecification.from(nodes, context)).toList();
        return new NodesSpecification(new ClusterResources(count, 1, resources), new ClusterResources(count, 1, resources), IntRange.empty(), true, context.getDeployState().getWantedNodeVespaVersion(), allContent.stream().anyMatch(content -> content.required), !context.getDeployState().getProperties().isBootstrap(), false, context.getDeployState().getWantedDockerImageRepo(), context.getDeployState().getProperties().cloudAccount(), false);
    }

    public ClusterResources minResources() {
        return this.min;
    }

    public ClusterResources maxResources() {
        return this.max;
    }

    public IntRange groupSize() {
        return this.groupSize;
    }

    public boolean isDedicated() {
        return this.dedicated;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean hasCountAttribute() {
        return this.hasCountAttribute;
    }

    public Map<HostResource, ClusterMembership> provision(HostSystem hostSystem, ClusterSpec.Type clusterType, ClusterSpec.Id clusterId, DeployLogger logger, boolean stateful, ClusterInfo clusterInfo) {
        return this.provision(hostSystem, clusterType, clusterId, ZoneEndpoint.defaultEndpoint, logger, stateful, clusterInfo);
    }

    public Map<HostResource, ClusterMembership> provision(HostSystem hostSystem, ClusterSpec.Type clusterType, ClusterSpec.Id clusterId, ZoneEndpoint zoneEndpoint, DeployLogger logger, boolean stateful, ClusterInfo info) {
        ClusterSpec cluster = ClusterSpec.request((ClusterSpec.Type)clusterType, (ClusterSpec.Id)clusterId).vespaVersion(this.version).exclusive(this.exclusive).dockerImageRepository(this.dockerImageRepo).loadBalancerSettings(zoneEndpoint).stateful(stateful).build();
        return hostSystem.allocateHosts(cluster, Capacity.from((ClusterResources)this.min, (ClusterResources)this.max, (IntRange)this.groupSize, (boolean)this.required, (boolean)this.canFail, this.cloudAccount, (ClusterInfo)info), logger);
    }

    private static Pair<NodeResources, NodeResources> nodeResources(ModelElement nodesElement) {
        ModelElement resources = nodesElement.child("resources");
        return resources == null ? new Pair((Object)NodeResources.unspecified(), (Object)NodeResources.unspecified()) : NodesSpecification.nodeResourcesFromResourcesElement(resources);
    }

    private static Pair<NodeResources, NodeResources> nodeResourcesFromResourcesElement(ModelElement element) {
        Pair<Double, Double> vcpu = NodesSpecification.toRange("vcpu", element, 0.0, Double::parseDouble);
        Pair<Double, Double> memory = NodesSpecification.toRange("memory", element, 0.0, s -> NodesSpecification.parseGbAmount(s, "B"));
        Pair<Double, Double> disk = NodesSpecification.toRange("disk", element, 0.0, s -> NodesSpecification.parseGbAmount(s, "B"));
        Pair<Double, Double> bandwith = NodesSpecification.toRange("bandwidth", element, 0.3, s -> NodesSpecification.parseGbAmount(s, "BPS"));
        NodeResources.DiskSpeed diskSpeed = NodesSpecification.parseOptionalDiskSpeed(element.stringAttribute("disk-speed"));
        NodeResources.StorageType storageType = NodesSpecification.parseOptionalStorageType(element.stringAttribute("storage-type"));
        NodeResources.Architecture architecture = NodesSpecification.parseOptionalArchitecture(element.stringAttribute("architecture"));
        NodeResources.GpuResources gpuResources = NodesSpecification.parseOptionalGpuResources(element.child("gpu"));
        NodeResources min = new NodeResources(((Double)vcpu.getFirst()).doubleValue(), ((Double)memory.getFirst()).doubleValue(), ((Double)disk.getFirst()).doubleValue(), ((Double)bandwith.getFirst()).doubleValue(), diskSpeed, storageType, architecture, gpuResources);
        NodeResources max = new NodeResources(((Double)vcpu.getSecond()).doubleValue(), ((Double)memory.getSecond()).doubleValue(), ((Double)disk.getSecond()).doubleValue(), ((Double)bandwith.getSecond()).doubleValue(), diskSpeed, storageType, architecture, gpuResources);
        return new Pair((Object)min, (Object)max);
    }

    private static NodeResources.GpuResources parseOptionalGpuResources(ModelElement element) {
        if (element == null) {
            return NodeResources.GpuResources.getDefault();
        }
        String type = element.stringAttribute("type");
        int count = element.requiredIntegerAttribute("count");
        double memory = NodesSpecification.parseGbAmount(element.requiredStringAttribute("memory"), "B");
        return new NodeResources.GpuResources(type, count, memory);
    }

    private static double parseGbAmount(String byteAmount, String unit) {
        byteAmount = byteAmount.strip();
        if ((byteAmount = byteAmount.toUpperCase()).endsWith(unit)) {
            byteAmount = byteAmount.substring(0, byteAmount.length() - unit.length());
        }
        double multiplier = -1.0;
        if (byteAmount.endsWith("K")) {
            multiplier = Math.pow(1000.0, -2.0);
        } else if (byteAmount.endsWith("M")) {
            multiplier = Math.pow(1000.0, -1.0);
        } else if (byteAmount.endsWith("G")) {
            multiplier = 1.0;
        } else if (byteAmount.endsWith("T")) {
            multiplier = 1000.0;
        } else if (byteAmount.endsWith("P")) {
            multiplier = Math.pow(1000.0, 2.0);
        } else if (byteAmount.endsWith("E")) {
            multiplier = Math.pow(1000.0, 3.0);
        } else if (byteAmount.endsWith("Z")) {
            multiplier = Math.pow(1000.0, 4.0);
        } else if (byteAmount.endsWith("Y")) {
            multiplier = Math.pow(1000.0, 5.0);
        }
        if (multiplier == -1.0) {
            multiplier = Math.pow(1000.0, -3.0);
        } else {
            byteAmount = byteAmount.substring(0, byteAmount.length() - 1).strip();
        }
        try {
            return Double.parseDouble(byteAmount) * multiplier;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid byte amount '" + byteAmount + "': Must be a floating point number optionally followed by k, M, G, T, P, E, Z or Y");
        }
    }

    private static NodeResources.DiskSpeed parseOptionalDiskSpeed(String diskSpeedString) {
        if (diskSpeedString == null) {
            return NodeResources.DiskSpeed.getDefault();
        }
        return switch (diskSpeedString) {
            case "fast" -> NodeResources.DiskSpeed.fast;
            case "slow" -> NodeResources.DiskSpeed.slow;
            case "any" -> NodeResources.DiskSpeed.any;
            default -> throw new IllegalArgumentException("Illegal disk-speed value '" + diskSpeedString + "': Legal values are 'fast', 'slow' and 'any')");
        };
    }

    private static NodeResources.StorageType parseOptionalStorageType(String storageTypeString) {
        if (storageTypeString == null) {
            return NodeResources.StorageType.getDefault();
        }
        return switch (storageTypeString) {
            case "remote" -> NodeResources.StorageType.remote;
            case "local" -> NodeResources.StorageType.local;
            case "any" -> NodeResources.StorageType.any;
            default -> throw new IllegalArgumentException("Illegal storage-type value '" + storageTypeString + "': Legal values are 'remote', 'local' and 'any')");
        };
    }

    private static NodeResources.Architecture parseOptionalArchitecture(String architecture) {
        if (architecture == null) {
            return NodeResources.Architecture.getDefault();
        }
        return switch (architecture) {
            case "x86_64" -> NodeResources.Architecture.x86_64;
            case "arm64" -> NodeResources.Architecture.arm64;
            case "any" -> NodeResources.Architecture.any;
            default -> throw new IllegalArgumentException("Illegal architecture value '" + architecture + "': Legal values are 'x86_64', 'arm64' and 'any')");
        };
    }

    private static ModelElement resolveElement(ModelElement nodesElement) {
        Element element = nodesElement.getXml();
        String referenceId = element.getAttribute("of");
        if (referenceId.isEmpty()) {
            return nodesElement;
        }
        Element services = NodesSpecification.findParentByTag("services", element).orElseThrow(() -> NodesSpecification.clusterReferenceNotFoundException(referenceId));
        Element referencedService = NodesSpecification.findChildById(services, referenceId).orElseThrow(() -> NodesSpecification.clusterReferenceNotFoundException(referenceId));
        if (!referencedService.getTagName().equals("content")) {
            throw new IllegalArgumentException("service '" + referenceId + "' is not a content service");
        }
        Element referencedNodesElement = XML.getChild((Element)referencedService, (String)"nodes");
        if (referencedNodesElement == null) {
            throw new IllegalArgumentException("expected reference to service '" + referenceId + "' to supply nodes, but that service has no <nodes> element");
        }
        return new ModelElement(referencedNodesElement);
    }

    private static Optional<Element> findChildById(Element parent, String id) {
        for (Element child : XML.getChildren((Element)parent)) {
            if (!id.equals(child.getAttribute("id"))) continue;
            return Optional.of(child);
        }
        return Optional.empty();
    }

    private static Optional<Element> findParentByTag(String tag, Element element) {
        Node parent = element.getParentNode();
        if (parent == null) {
            return Optional.empty();
        }
        if (!(parent instanceof Element)) {
            return Optional.empty();
        }
        Element parentElement = (Element)parent;
        if (parentElement.getTagName().equals(tag)) {
            return Optional.of(parentElement);
        }
        return NodesSpecification.findParentByTag(tag, parentElement);
    }

    private static IllegalArgumentException clusterReferenceNotFoundException(String referenceId) {
        return new IllegalArgumentException("referenced service '" + referenceId + "' is not defined");
    }

    private static Optional<DockerImage> dockerImageToUse(ModelElement nodesElement, Optional<DockerImage> dockerImage) {
        String dockerImageFromElement = nodesElement.stringAttribute("docker-image");
        return dockerImageFromElement == null ? dockerImage : Optional.of(DockerImage.fromString((String)dockerImageFromElement));
    }

    private static Pair<Double, Double> toRange(String name, ModelElement element, double defaultValue, ToDoubleFunction<String> valueParser) {
        String s = element.stringAttribute(name);
        try {
            Pair pair;
            if (s == null) {
                return new Pair((Object)defaultValue, (Object)defaultValue);
            }
            if ((s = s.trim()).startsWith("[") && s.endsWith("]")) {
                String[] numbers = s.substring(1, s.length() - 1).split(",");
                if (numbers.length != 2) {
                    throw new IllegalArgumentException();
                }
                pair = new Pair((Object)valueParser.applyAsDouble(numbers[0].trim()), (Object)valueParser.applyAsDouble(numbers[1].trim()));
                if ((Double)pair.getFirst() > (Double)pair.getSecond()) {
                    throw new IllegalArgumentException("first value cannot be larger than second value");
                }
            } else {
                pair = new Pair((Object)valueParser.applyAsDouble(s), (Object)valueParser.applyAsDouble(s));
            }
            if ((Double)pair.getFirst() < 0.0 || (Double)pair.getSecond() < 0.0) {
                throw new IllegalArgumentException("values cannot be negative");
            }
            return pair;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Expected a number or range on the form [min, max] for node resource '" + name + "', but got '" + s + "'", e);
        }
    }

    public String toString() {
        return "specification of " + (this.dedicated ? "dedicated " : "") + String.valueOf(this.min.equals((Object)this.max) ? this.min : "min " + String.valueOf(this.min) + " max " + String.valueOf(this.max));
    }

    private record ResourceConstraints(ClusterResources min, ClusterResources max, IntRange groupSize) {
    }
}

