/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class IndexFieldNames
extends Processor {
    private static final String FIELD_NAME_REGEXP = "[a-zA-Z]\\w*";

    public IndexFieldNames(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.schema.allConcreteFields()) {
            if (field.getName().matches(FIELD_NAME_REGEXP) || this.legalDottedPositionField(field)) continue;
            this.fail(this.schema, field, " Not a legal field name. Legal expression: [a-zA-Z]\\w*");
        }
    }

    private boolean legalDottedPositionField(SDField field) {
        return field.getName().endsWith(".position") || field.getName().endsWith(".distance");
    }
}

