/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component;

import com.yahoo.component.Version;

public final class VersionSpecification
implements Comparable<VersionSpecification> {
    private Integer major = null;
    private Integer minor = null;
    private Integer micro = null;
    private String qualifier = null;
    private String stringValue;
    public static final VersionSpecification emptyVersionSpecification = new VersionSpecification();

    public VersionSpecification() {
        this(null, null, null, null);
    }

    public VersionSpecification(Integer major) {
        this(major, null, null, null);
    }

    public VersionSpecification(Integer major, Integer minor) {
        this(major, minor, null, null);
    }

    public VersionSpecification(Integer major, Integer minor, Integer micro) {
        this(major, minor, micro, null);
    }

    public VersionSpecification(Integer major, Integer minor, Integer micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.initialize();
    }

    public VersionSpecification(String versionString) {
        if (!"".equals(versionString)) {
            String s;
            String[] components = versionString.split("\\x2e");
            if (components.length > 0 && !(s = components[0]).equals("*")) {
                this.major = Integer.valueOf(s);
            }
            if (components.length > 1 && !(s = components[1]).equals("*")) {
                this.minor = Integer.valueOf(s);
            }
            if (components.length > 2 && !(s = components[2]).equals("*")) {
                this.micro = Integer.valueOf(s);
            }
            if (components.length > 3) {
                this.qualifier = components[3];
            }
            if (components.length > 4) {
                throw new IllegalArgumentException("Too many components in " + versionString);
            }
        }
        this.initialize();
    }

    public static VersionSpecification fromString(String versionString) {
        if (versionString == null) {
            return emptyVersionSpecification;
        }
        return new VersionSpecification(versionString);
    }

    private void initialize() {
        this.stringValue = this.toStringValue(this.major, this.minor, this.micro, this.qualifier);
        this.ensureUnspecifiedOnlyToTheRight(this.major, this.minor, this.micro, this.qualifier);
        if (this.major != null && this.major < 0) {
            throw new IllegalArgumentException("Negative major in " + String.valueOf(this));
        }
        if (this.minor != null && this.minor < 0) {
            throw new IllegalArgumentException("Negative minor in " + String.valueOf(this));
        }
        if (this.micro != null && this.micro < 0) {
            throw new IllegalArgumentException("Negative micro in " + String.valueOf(this));
        }
        String q = this.getQualifier();
        for (int i = 0; i < q.length(); ++i) {
            if (Character.isLetterOrDigit(q.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid qualifier in " + String.valueOf(this) + ": Invalid character at position " + i + " in qualifier");
        }
    }

    private String toStringValue(Object ... objects) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Object o : objects) {
            if (o == null) continue;
            if (!first) {
                b.append(".");
            }
            b.append(o);
            first = false;
        }
        return b.toString();
    }

    private void ensureUnspecifiedOnlyToTheRight(Object ... objects) {
        boolean restMustBeNull = false;
        for (Object o : objects) {
            if (restMustBeNull && o != null) {
                throw new IllegalArgumentException("A component to the left of a specified is unspecified in " + String.valueOf(this));
            }
            if (o != null) continue;
            restMustBeNull = true;
        }
    }

    public int getMajor() {
        return this.major != null ? this.major : 0;
    }

    public int getMinor() {
        return this.minor != null ? this.minor : 0;
    }

    public int getMicro() {
        return this.micro != null ? this.micro : 0;
    }

    public String getQualifier() {
        return this.qualifier != null ? this.qualifier : "";
    }

    public Integer getSpecifiedMajor() {
        return this.major;
    }

    public Integer getSpecifiedMinor() {
        return this.minor;
    }

    public Integer getSpecifiedMicro() {
        return this.micro;
    }

    public String getSpecifiedQualifier() {
        return this.qualifier;
    }

    public String toString() {
        return this.stringValue;
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VersionSpecification)) {
            return false;
        }
        VersionSpecification other = (VersionSpecification)object;
        if (!this.equals(this.major, other.major)) {
            return false;
        }
        if (!this.equals(this.minor, other.minor)) {
            return false;
        }
        if (!this.equals(this.micro, other.micro)) {
            return false;
        }
        return this.equals(this.qualifier, other.qualifier);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public boolean isEmpty() {
        return this.equals(emptyVersionSpecification);
    }

    public Version lowestMatchingVersion() {
        return new Version(this.getMajor(), this.getMinor(), this.getMicro(), this.getQualifier());
    }

    public boolean matches(Version version) {
        if (this.matches(this.major, version.getMajor()) && this.matches(this.minor, version.getMinor()) && this.matches(this.micro, version.getMicro())) {
            return version.getQualifier().equals(this.getQualifier());
        }
        return false;
    }

    private boolean matches(Integer componentSpec, Integer component) {
        if (componentSpec == null) {
            return true;
        }
        return componentSpec.equals(component);
    }

    @Override
    public int compareTo(VersionSpecification other) {
        int result = this.getMajor() - other.getMajor();
        if (result != 0) {
            return result;
        }
        result = this.getMinor() - other.getMinor();
        if (result != 0) {
            return result;
        }
        result = this.getMicro() - other.getMicro();
        if (result != 0) {
            return result;
        }
        return this.getQualifier().compareTo(other.getQualifier());
    }

    public VersionSpecification intersect(VersionSpecification other) {
        return new VersionSpecification(this.intersect(this.major, other.major, "major"), this.intersect(this.minor, other.minor, "minor"), this.intersect(this.micro, other.micro, "micro"), this.intersect(this.qualifier, other.qualifier, "qualifier"));
    }

    private <T> T intersect(T spec1, T spec2, String name) {
        if (spec1 == null) {
            return spec2;
        }
        if (spec2 == null) {
            return spec1;
        }
        if (spec1.equals(spec2)) {
            return spec1;
        }
        throw new RuntimeException("The " + name + " component does not match(" + String.valueOf(spec1) + "!=" + String.valueOf(spec2) + ").");
    }
}

