/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.json.support.hutool;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONUtil;
import com.xkcoding.json.config.JsonConfig;
import com.xkcoding.json.exception.SimpleJsonException;
import com.xkcoding.json.support.AbstractJsonAdapter;
import com.xkcoding.json.util.StringUtil;

public class HutoolJsonJsonAdapter
extends AbstractJsonAdapter {
    private static JSONConfig hutoolJsonConfig;

    public HutoolJsonJsonAdapter() {
        this(new JsonConfig());
    }

    public HutoolJsonJsonAdapter(JsonConfig jsonConfig) {
        super(jsonConfig);
        this.configureHutoolJson(jsonConfig);
    }

    @Override
    public void setJsonConfig(JsonConfig jsonConfig) {
        super.setJsonConfig(jsonConfig);
        this.configureHutoolJson(jsonConfig);
    }

    private void configureHutoolJson(JsonConfig jsonConfig) {
        hutoolJsonConfig = StringUtil.isNotEmpty(jsonConfig.getDateFormat()) ? JSONConfig.create().setDateFormat(jsonConfig.getDateFormat()) : JSONConfig.create();
    }

    @Override
    public String serialize(Object obj) throws SimpleJsonException {
        return JSONUtil.toJsonStr((JSON)JSONUtil.parse((Object)obj, (JSONConfig)hutoolJsonConfig));
    }

    @Override
    public <T> T deserialize(String jsonStr, Class<T> clazz) throws SimpleJsonException {
        return (T)JSONUtil.parse((Object)jsonStr, (JSONConfig)hutoolJsonConfig).toBean(clazz);
    }
}

