/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.json;

import com.xkcoding.json.config.JsonConfig;
import com.xkcoding.json.exception.SimpleJsonException;
import com.xkcoding.json.support.AbstractJsonAdapter;
import com.xkcoding.json.support.JsonAdapter;
import com.xkcoding.json.support.fastjson.FastJsonJsonAdapter;
import com.xkcoding.json.support.gson.GsonJsonAdapter;
import com.xkcoding.json.support.hutool.HutoolJsonJsonAdapter;
import com.xkcoding.json.support.jackson.JacksonJsonAdapter;
import com.xkcoding.json.util.ClassUtil;
import com.xkcoding.json.util.Kv;

public final class JsonUtil {
    private static AbstractJsonAdapter jsonAdapter;

    private static void checkJsonAdapterNotNull(JsonAdapter jsonAdapter) {
        if (null == jsonAdapter) {
            JsonUtil.selectJsonAdapter();
        }
    }

    private static void selectJsonAdapter() {
        AbstractJsonAdapter defaultJsonAdapter = null;
        ClassLoader classLoader = JsonUtil.class.getClassLoader();
        if (null == defaultJsonAdapter && ClassUtil.isPresent("com.fasterxml.jackson.databind.ObjectMapper", classLoader)) {
            defaultJsonAdapter = JsonUtil.getJsonAdapter(JacksonJsonAdapter.class);
        }
        if (null == defaultJsonAdapter && ClassUtil.isPresent("com.alibaba.fastjson.JSON", classLoader)) {
            defaultJsonAdapter = JsonUtil.getJsonAdapter(FastJsonJsonAdapter.class);
        }
        if (null == defaultJsonAdapter && ClassUtil.isPresent("com.google.gson.Gson", classLoader)) {
            defaultJsonAdapter = JsonUtil.getJsonAdapter(GsonJsonAdapter.class);
        }
        if (null == defaultJsonAdapter && ClassUtil.isPresent("cn.hutool.json.JSONUtil", classLoader)) {
            defaultJsonAdapter = JsonUtil.getJsonAdapter(HutoolJsonJsonAdapter.class);
        }
        if (defaultJsonAdapter == null) {
            throw new SimpleJsonException("Has no JsonImpl defined in environment!");
        }
        jsonAdapter = defaultJsonAdapter;
    }

    private static <T extends AbstractJsonAdapter> AbstractJsonAdapter getJsonAdapter(Class<T> clazz) {
        try {
            return (AbstractJsonAdapter)clazz.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void setJsonAdapter(AbstractJsonAdapter jsonAdapter) {
        JsonUtil.jsonAdapter = jsonAdapter;
    }

    public static void setConfig(JsonConfig jsonConfig) {
        JsonUtil.checkJsonAdapterNotNull(jsonAdapter);
        if (null == jsonConfig) {
            jsonConfig = new JsonConfig();
        }
        jsonAdapter.setJsonConfig(jsonConfig);
    }

    public static String toJsonString(Object obj) {
        JsonUtil.checkJsonAdapterNotNull(jsonAdapter);
        return jsonAdapter.serialize(obj);
    }

    public static <T> T toBean(String jsonStr, Class<T> clazz) {
        JsonUtil.checkJsonAdapterNotNull(jsonAdapter);
        return jsonAdapter.deserialize(jsonStr, clazz);
    }

    public static Kv parseKv(String jsonStr) {
        return JsonUtil.toBean(jsonStr, Kv.class);
    }

    private JsonUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

