/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.io;

import java.util.concurrent.TimeUnit;

public class TimingOutProcessExecutor {
    public static int waitFor(Process p, long timeoutNanos) throws InterruptedException {
        long startTime = System.nanoTime();
        long rem = timeoutNanos;
        while (true) {
            try {
                return p.exitValue();
            }
            catch (IllegalThreadStateException ex) {
                if (rem <= 0L) continue;
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                if ((rem = timeoutNanos - (System.nanoTime() - startTime)) > 0L) continue;
                p.destroy();
                throw new InterruptedException(String.format("Timeout of %s sec exceeded while waiting for process to complete", TimeUnit.NANOSECONDS.toSeconds(timeoutNanos)));
            }
            break;
        }
    }
}

