/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.io;

import de.flapdoodle.embed.process.io.IStreamProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class NotifyingStreamProcessor
implements IStreamProcessor {
    private final List<ResultMatchingListener> listeners = new ArrayList<ResultMatchingListener>();
    private final IStreamProcessor delegate;

    public NotifyingStreamProcessor(IStreamProcessor processor) {
        this.delegate = processor;
    }

    public ResultMatchingListener addListener(ResultMatchingListener listener) {
        this.listeners.add(listener);
        return listener;
    }

    public void process(String block) {
        for (ResultMatchingListener listener : this.listeners) {
            listener.onMessage(block);
        }
        this.delegate.process(block);
    }

    public void onProcessed() {
    }

    public static class ResultMatchingListener {
        private final String successPattern;
        private final String failurePattern = "[ERROR]";
        private final StringBuilder output = new StringBuilder();
        private boolean initWithSuccess = false;
        private String failureFound = null;
        private boolean completed = false;

        public ResultMatchingListener(String successPattern) {
            this.successPattern = successPattern;
        }

        public void onMessage(String message) {
            this.output.append(message);
            if (this.containsPattern()) {
                this.gotResult(true, null);
            } else {
                int failureIndex = this.output.indexOf("[ERROR]");
                if (failureIndex != -1) {
                    this.gotResult(false, this.output.substring(failureIndex));
                }
            }
        }

        private boolean containsPattern() {
            return this.output.indexOf(this.successPattern) != -1;
        }

        private synchronized void gotResult(boolean success, String message) {
            this.initWithSuccess = success;
            this.failureFound = message;
            this.completed = true;
            this.notify();
        }

        public synchronized void waitForResult(long timeoutMs) {
            try {
                this.wait(timeoutMs);
                if (!this.completed) {
                    throw new RuntimeException(String.format("Timeout of %s sec exceeded while waiting for process to complete", TimeUnit.MILLISECONDS.toSeconds(timeoutMs)));
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public boolean isInitWithSuccess() {
            return this.initWithSuccess;
        }

        public String getFailureFound() {
            return this.failureFound;
        }
    }
}

