/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.distribution;

import com.wix.mysql.exceptions.UnsupportedPlatformException;
import com.wix.mysql.utils.Utils;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.distribution.Platform;
import java.util.Arrays;
import java.util.List;

public enum Version implements IVersion
{
    v5_5_40("5.5", 40, MacOsVersion.v10_6, Platform.Linux, Platform.OS_X),
    v5_5_50("5.5", 50, MacOsVersion.v10_9, Platform.Linux, Platform.OS_X),
    v5_5_51("5.5", 51, MacOsVersion.v10_9, Platform.Linux, Platform.OS_X),
    v5_5_52("5.5", 52, MacOsVersion.v10_9, Platform.Linux, Platform.OS_X),
    v5_5_latest(v5_5_52),
    v5_6_21("5.6", 21, MacOsVersion.v10_9),
    v5_6_22("5.6", 22, MacOsVersion.v10_9),
    v5_6_23("5.6", 23, MacOsVersion.v10_9),
    v5_6_24("5.6", 24, MacOsVersion.v10_9),
    v5_6_31("5.6", 31, MacOsVersion.v10_11),
    v5_6_32("5.6", 32, MacOsVersion.v10_11),
    v5_6_33("5.6", 33, MacOsVersion.v10_11),
    v5_6_34("5.6", 34, MacOsVersion.v10_11),
    v5_6_35("5.6", 35, MacOsVersion.v10_12),
    v5_6_latest(v5_6_35),
    v5_7_10("5.7", 10, MacOsVersion.v10_10),
    v5_7_13("5.7", 13, MacOsVersion.v10_11),
    v5_7_14("5.7", 14, MacOsVersion.v10_11),
    v5_7_15("5.7", 15, MacOsVersion.v10_11),
    v5_7_16("5.7", 16, MacOsVersion.v10_11),
    v5_7_17("5.7", 17, MacOsVersion.v10_12),
    v5_7_latest(v5_7_17);

    private final String majorVersion;
    private final int minorVersion;
    private final MacOsVersion macOsVersion;
    private final List<Platform> supportedPlatforms;

    private Version(String majorVersion, int minorVersion, MacOsVersion macOsVersion, Platform ... supportedPlatforms) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.macOsVersion = macOsVersion;
        this.supportedPlatforms = Arrays.asList(supportedPlatforms);
    }

    private Version(String majorVersion, int minorVersion, MacOsVersion macOsVersion) {
        this(majorVersion, minorVersion, macOsVersion, Platform.Linux, Platform.Windows, Platform.OS_X);
    }

    private Version(Version other) {
        this.majorVersion = other.majorVersion;
        this.minorVersion = other.minorVersion;
        this.macOsVersion = other.macOsVersion;
        this.supportedPlatforms = other.supportedPlatforms;
    }

    public boolean supportsCurrentPlatform() {
        return this.supportedPlatforms.contains(this.currentPlatform()) && (!this.isMacOsSierra() || this.worksOnMacOsSierra());
    }

    private boolean isMacOsSierra() {
        return this.currentPlatform() == Platform.OS_X && System.getProperty("os.version").startsWith("10.12");
    }

    private boolean worksOnMacOsSierra() {
        return !this.majorVersion.equals("5.7") || this.minorVersion >= 15;
    }

    public String asInDownloadPath() {
        this.assertPlatformIsSupported();
        switch (this.currentPlatform()) {
            case Windows: {
                return String.format("%s/mysql-%s.%s", this.path(), this.majorVersion, this.minorVersion);
            }
            case OS_X: {
                return String.format("%s/mysql-%s.%s-%s", new Object[]{this.path(), this.majorVersion, this.minorVersion, this.macOsVersion});
            }
            case Linux: {
                return String.format("%s/mysql-%s.%s-%s", this.path(), this.majorVersion, this.minorVersion, this.gcLibVersion());
            }
        }
        throw new UnsupportedPlatformException("Unrecognized platform, currently not supported");
    }

    public String toString() {
        return String.format("Version %s.%s", this.majorVersion, this.minorVersion);
    }

    private String gcLibVersion() {
        if (this.majorVersion.equals("5.6") || this.majorVersion.equals("5.7")) {
            return "linux-glibc2.5";
        }
        if (this.majorVersion.equals("5.5")) {
            return "linux2.6";
        }
        throw new UnsupportedOperationException();
    }

    private Platform currentPlatform() {
        return Platform.detect();
    }

    private String path() {
        return String.format("MySQL-%s", this.majorVersion);
    }

    private void assertPlatformIsSupported() {
        if (!this.supportsCurrentPlatform()) {
            throw new UnsupportedPlatformException(String.format("Platform %s is not in a supported platform list: %s", this.currentPlatform().name(), Utils.join(this.supportedPlatforms, ",")));
        }
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    private static enum MacOsVersion {
        v10_6("osx"),
        v10_9("osx"),
        v10_10("osx"),
        v10_11("osx"),
        v10_12("macos");

        private final String osName;

        private MacOsVersion(String osName) {
            this.osName = osName;
        }

        public String toString() {
            return String.format("%s%s", this.osName, this.name().substring(1).replace('_', '.'));
        }
    }
}

