/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.wix.mysql.Sources;
import com.wix.mysql.SqlScriptSource;
import com.wix.mysql.utils.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class ScriptResolver {
    public static List<SqlScriptSource> classPathScripts(String pattern) {
        ArrayList<SqlScriptSource> results = new ArrayList<SqlScriptSource>();
        String[] parts = pattern.split("/");
        String path = Utils.join(Arrays.asList(Arrays.copyOfRange(parts, 0, parts.length - 1)), "/");
        String normalizedPath = path.startsWith("/") ? path : String.format("/%s", path);
        URL baseFolder = ScriptResolver.class.getResource(normalizedPath);
        if (baseFolder == null) {
            throw new ScriptResolutionException(normalizedPath);
        }
        if (baseFolder.getProtocol().equals("jar")) {
            JarFile jar;
            String normalizedPattern = pattern.startsWith("/") ? pattern : String.format("/%s", pattern);
            String regexPattern = normalizedPattern.replace("*", ".*");
            String jarPath = baseFolder.getPath().substring(5, baseFolder.getPath().indexOf("!"));
            try {
                jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Enumeration<JarEntry> entries = jar.entries();
            ArrayList<String> names = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                String name = "/" + entries.nextElement().getName();
                if (!name.matches(regexPattern)) continue;
                names.add(name);
            }
            Collections.sort(names);
            for (String found : names) {
                results.add(ScriptResolver.classPathScript(found));
            }
        } else {
            WildcardFileFilter filter = new WildcardFileFilter(parts[parts.length - 1]);
            List<File> filesInPath = Arrays.asList(ScriptResolver.asFile(baseFolder).listFiles((FileFilter)filter));
            Collections.sort(filesInPath);
            for (File f : filesInPath) {
                results.add(Sources.fromFile(f));
            }
        }
        return results;
    }

    public static SqlScriptSource classPathScript(String path) {
        String normalizedPath = path.startsWith("/") ? path : String.format("/%s", path);
        URL resource = ScriptResolver.class.getResource(normalizedPath);
        if (resource == null) {
            throw new ScriptResolutionException(normalizedPath);
        }
        return Sources.fromURL(resource);
    }

    @Deprecated
    public static SqlScriptSource classPathFile(String path) {
        return ScriptResolver.classPathScript(path);
    }

    @Deprecated
    public static List<SqlScriptSource> classPathFiles(String pattern) {
        return ScriptResolver.classPathScripts(pattern);
    }

    private static File asFile(URL resource) {
        try {
            return new File(resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ScriptResolutionException
    extends RuntimeException {
        ScriptResolutionException(String path) {
            super(String.format("No script(s) found for path '%s'", path));
        }
    }
}

