/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.standard.common.service;

import com.webank.wedatasphere.dss.standard.common.exception.AppStandardWarnException;
import com.webank.wedatasphere.dss.standard.common.service.AppService;
import com.webank.wedatasphere.dss.standard.common.service.Operation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AppServiceImpl
implements AppService {
    private Set<Class<? extends Operation>> necessaryOperations = new HashSet<Class<? extends Operation>>();

    protected void registerNecessaryOperation(Class<? extends Operation> clazz) {
        this.necessaryOperations.add(clazz);
    }

    @Override
    public Operation createOperation(Class<? extends Operation> clazz) {
        String clazzSimpleName = clazz.getSimpleName();
        List methodList = Arrays.stream(this.getClass().getDeclaredMethods()).filter(method -> method.getReturnType() == clazz && method.getParameterCount() == 0).collect(Collectors.toList());
        if (methodList.size() == 1) {
            try {
                return (Operation)((Method)methodList.get(0)).invoke((Object)this, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new AppStandardWarnException(80020, "Not exists operation: " + clazzSimpleName, e);
            }
        }
        if (methodList.isEmpty()) {
            return this.notFoundOperation(clazz);
        }
        return this.multiFoundOperation(clazz);
    }

    protected Operation notFoundOperation(Class<? extends Operation> clazz) {
        throw new AppStandardWarnException(80020, "Not exists operation: " + clazz.getSimpleName());
    }

    protected Operation multiFoundOperation(Class<? extends Operation> clazz) {
        throw new AppStandardWarnException(80020, "Multi exists operations: " + clazz.getSimpleName());
    }

    @Override
    public boolean isOperationExists(Class<? extends Operation> clazz) {
        try {
            return this.createOperation(clazz) != null;
        }
        catch (AppStandardWarnException e) {
            return false;
        }
    }

    @Override
    public boolean isOperationNecessary(Class<? extends Operation> clazz) {
        boolean isNecessary = this.necessaryOperations.contains(clazz);
        if (isNecessary) {
            return true;
        }
        return this.isOperationExists(clazz);
    }
}

