/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.standard.common.entity.ref;

import com.webank.wedatasphere.dss.common.exception.DSSErrorException;
import com.webank.wedatasphere.dss.common.utils.ClassUtils;
import com.webank.wedatasphere.dss.common.utils.DSSExceptionUtils;
import com.webank.wedatasphere.dss.standard.common.entity.ref.Ref;
import com.webank.wedatasphere.dss.standard.common.entity.ref.RefFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRefFactory
implements RefFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRefFactory.class);
    private Map<RefKey, Class<? extends Ref>> cacheMap = new ConcurrentHashMap<RefKey, Class<? extends Ref>>(16);

    @Override
    public <R extends Ref> R newRef(Class<R> clazz) throws DSSErrorException {
        if (!org.apache.linkis.common.utils.ClassUtils.isInterfaceOrAbstract(clazz)) {
            return (R)((Ref)DSSExceptionUtils.tryAndWarn(Void2 -> (Ref)clazz.newInstance()));
        }
        return (R)((Ref)ClassUtils.getInstance(clazz));
    }

    @Override
    public <R extends Ref> R newRef(Class<R> clazz, ClassLoader classLoader, String packageName) throws DSSErrorException {
        RefKey refKey = new RefKey(classLoader, clazz, packageName);
        Class<? extends Ref> refClass = this.cacheMap.get(refKey);
        if (this.cacheMap.containsKey(refKey) && refClass != null) {
            return (R)((Ref)DSSExceptionUtils.tryAndWarn(Void2 -> (Ref)refClass.newInstance()));
        }
        if (this.cacheMap.containsKey(refKey) && refClass == null) {
            return this.newRef(clazz);
        }
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.addClassLoader(classLoader);
        configurationBuilder.addClassLoader(clazz.getClassLoader());
        configurationBuilder.forPackages(new String[]{packageName});
        Collection urls = ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{classLoader});
        configurationBuilder.addUrls((Collection)urls.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        configurationBuilder.addScanners(new Scanner[]{new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set subClasses = reflections.getSubTypesOf(clazz).stream().filter(c -> !org.apache.linkis.common.utils.ClassUtils.isInterfaceOrAbstract((Class)c)).collect(Collectors.toSet());
        if (subClasses.isEmpty()) {
            this.cacheMap.put(refKey, null);
            return this.newRef(clazz);
        }
        Set realSubClasses = subClasses;
        if (subClasses.size() > 1) {
            LOGGER.warn("subClass of {} size is {}, classes are {}", new Object[]{clazz.getName(), subClasses.size(), subClasses});
            realSubClasses = subClasses.stream().filter(subClass -> subClass.getName().contains(packageName) && !subClass.isInterface()).collect(Collectors.toSet());
            LOGGER.warn("realSubClasses is {} ", realSubClasses);
        }
        if (realSubClasses.size() > 1) {
            LOGGER.error("realSubClasses size is bigger than 1");
            DSSExceptionUtils.dealErrorException((int)60091, (String)("too many subclass of " + clazz.getName() + "in " + packageName), DSSErrorException.class);
        } else if (realSubClasses.size() == 0) {
            this.cacheMap.put(refKey, null);
            return this.newRef(clazz);
        }
        Class subClass2 = (Class)realSubClasses.iterator().next();
        this.cacheMap.put(refKey, subClass2);
        return (R)((Ref)DSSExceptionUtils.tryAndWarn(Void2 -> (Ref)subClass2.newInstance()));
    }

    private class RefKey {
        private ClassLoader classLoader;
        private Class<? extends Ref> clazz;
        private String packageName;

        public RefKey(ClassLoader classLoader, Class<? extends Ref> clazz, String packageName) {
            this.classLoader = classLoader;
            this.clazz = clazz;
            this.packageName = packageName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RefKey refKey = (RefKey)o;
            return com.google.common.base.Objects.equal((Object)this.classLoader, (Object)refKey.classLoader) && com.google.common.base.Objects.equal(this.clazz, refKey.clazz) && com.google.common.base.Objects.equal((Object)this.packageName, (Object)refKey.packageName);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.classLoader, this.clazz, this.packageName});
        }
    }
}

