/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.standard.common.entity.ref;

import com.webank.wedatasphere.dss.common.utils.DSSCommonUtils;
import com.webank.wedatasphere.dss.standard.common.entity.ref.AbstractResponseRef;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CommonResponseRef
extends AbstractResponseRef {
    public CommonResponseRef(String responseBody, int status) {
        super(responseBody, status);
        this.init();
    }

    protected void init() {
        this.responseMap = StringUtils.isNotBlank((String)this.responseBody) ? (Map)DSSCommonUtils.COMMON_GSON.fromJson(this.responseBody, Map.class) : new HashMap();
    }

    public CommonResponseRef() {
        this("", 0);
    }

    @Override
    public Map<String, Object> toMap() {
        return this.responseMap;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public Object getValue(String key) {
        return this.responseMap.get(key);
    }

    public void addResponse(String key, Object value) {
        this.responseMap.put(key, value);
    }

    public static CommonResponseRef success() {
        return new CommonResponseRef();
    }

    public static CommonResponseRef success(String message) {
        CommonResponseRef commonResponseRef = new CommonResponseRef();
        commonResponseRef.responseBody = message;
        return commonResponseRef;
    }

    public static CommonResponseRef error(String errorMsg, Throwable cause) {
        CommonResponseRef commonResponseRef = new CommonResponseRef();
        commonResponseRef.status = 1;
        commonResponseRef.errorMsg = errorMsg;
        return commonResponseRef;
    }

    public static CommonResponseRef error(String errorMsg) {
        return CommonResponseRef.error(errorMsg, null);
    }
}

