/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.standard.common.desc;

import com.webank.wedatasphere.dss.common.label.DSSLabel;
import com.webank.wedatasphere.dss.standard.common.desc.AppDesc;
import com.webank.wedatasphere.dss.standard.common.desc.AppInstance;
import com.webank.wedatasphere.dss.standard.common.exception.NoSuchAppInstanceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDescImpl
implements AppDesc {
    private static final Logger LOG = LoggerFactory.getLogger(AppDescImpl.class);
    private String appName;
    private List<AppInstance> appInstances = new ArrayList<AppInstance>();

    @Override
    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public List<AppInstance> getAppInstances() {
        return this.appInstances;
    }

    @Override
    public List<AppInstance> getAppInstancesByLabels(List<DSSLabel> labels) throws NoSuchAppInstanceException {
        AppInstance targetAppInstance = null;
        int similarity = 0;
        int maxSimilarity = 0;
        for (AppInstance appInstance : this.appInstances) {
            similarity = 0;
            List<DSSLabel> targetLabels = appInstance.getLabels();
            for (DSSLabel label : targetLabels) {
                for (DSSLabel userLabel : labels) {
                    if (this.isEqualLabel(userLabel, label)) {
                        ++similarity;
                    }
                    if (similarity <= maxSimilarity) continue;
                    maxSimilarity = similarity;
                    targetAppInstance = appInstance;
                }
            }
        }
        if (maxSimilarity <= 0) {
            LOG.error("{} has no such AppInstance machs the labels: {}", (Object)this.appName, labels);
            throw new NoSuchAppInstanceException(60002, "No such AppInstance machs the labels.");
        }
        return Arrays.asList(targetAppInstance);
    }

    public boolean isEqualLabel(DSSLabel userLabel, DSSLabel label) {
        boolean flag = false;
        DSSLabel tempUserLabel = userLabel;
        String userEnv = (String)((Map)tempUserLabel.getValue()).get(tempUserLabel.getLabelKey());
        DSSLabel tempLabel = label;
        String instanceEnv = (String)((Map)tempLabel.getValue()).get(tempLabel.getLabelKey());
        if (StringUtils.isNotBlank((String)userEnv) && userEnv.equalsIgnoreCase(instanceEnv)) {
            flag = true;
        }
        return flag;
    }

    public List<AppInstance> getAppInstancesByLabels(List<DSSLabel> labels, Comparator comparator) {
        return null;
    }

    @Override
    public void addAppInstance(AppInstance appInstance) {
        this.appInstances.add(appInstance);
    }

    @Override
    public void removeAppInstance(AppInstance appInstance) {
        this.appInstances.remove(appInstance);
    }
}

