/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.jersey;

import com.wavefront.sdk.common.Pair;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.model.Resource;

abstract class MetricNameUtils {
    static final String REQUEST_PREFIX = "request.";
    static final String RESPONSE_PREFIX = "response.";

    MetricNameUtils() {
    }

    static Optional<Pair<String, String>> metricNameAndPath(ContainerRequest request) {
        Resource matchedResource = request.getUriInfo().getMatchedModelResource();
        if (matchedResource != null) {
            StringBuilder matchingPath = new StringBuilder(MetricNameUtils.stripLeadingAndTrailingSlashes(matchedResource.getPath()));
            while (matchedResource.getParent() != null) {
                matchedResource = matchedResource.getParent();
                matchingPath.insert(0, MetricNameUtils.stripLeadingAndTrailingSlashes(matchedResource.getPath()) + "/");
            }
            Optional<String> optionalMetricName = MetricNameUtils.metricName(request.getMethod(), matchingPath.toString());
            return optionalMetricName.map(metricName -> new Pair(metricName, (Object)matchingPath.toString()));
        }
        return Optional.empty();
    }

    private static Optional<String> metricName(String httpMethod, String path) {
        String metricId = MetricNameUtils.stripLeadingAndTrailingSlashes(path);
        if (StringUtils.isBlank((CharSequence)(metricId = metricId.replace('/', '.').replace(":", "").replace("{", "_").replace("}", "_")))) {
            return Optional.empty();
        }
        return Optional.of(metricId + "." + httpMethod);
    }

    private static String stripLeadingAndTrailingSlashes(String path) {
        return path == null ? "" : StringUtils.strip((String)path, (String)"/");
    }
}

