/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm;

import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Metric;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricRegistry;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricSet;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm.JmxAttributeGauge;
import com.wavefront.internal_reporter_java.org.slf4j.Logger;
import com.wavefront.internal_reporter_java.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class BufferPoolMetricSet
implements MetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferPoolMetricSet.class);
    private static final String[] ATTRIBUTES = new String[]{"Count", "MemoryUsed", "TotalCapacity"};
    private static final String[] NAMES = new String[]{"count", "used", "capacity"};
    private static final String[] POOLS = new String[]{"direct", "mapped"};
    private final MBeanServer mBeanServer;

    public BufferPoolMetricSet(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, JmxAttributeGauge> gauges = new HashMap<MetricName, JmxAttributeGauge>();
        for (String pool : POOLS) {
            for (int i = 0; i < ATTRIBUTES.length; ++i) {
                String attribute = ATTRIBUTES[i];
                String name = NAMES[i];
                try {
                    ObjectName on = new ObjectName("java.nio:type=BufferPool,name=" + pool);
                    this.mBeanServer.getMBeanInfo(on);
                    gauges.put(MetricRegistry.name(pool, name), new JmxAttributeGauge(this.mBeanServer, on, attribute));
                    continue;
                }
                catch (JMException ignored) {
                    LOGGER.debug("Unable to load buffer pool MBeans, possibly running on Java 6");
                }
            }
        }
        return Collections.unmodifiableMap(gauges);
    }
}

