/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.config;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.wavefront.config.ApplicationTagsConfig;
import com.wavefront.config.WavefrontReportingConfig;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.direct.ingestion.WavefrontDirectIngestionClient;
import com.wavefront.sdk.proxy.WavefrontProxyClient;
import java.io.File;
import java.io.IOException;

public class ReportingUtils {
    public static WavefrontSender constructWavefrontSender(WavefrontReportingConfig wfReportingConfig) {
        String reportingMechanism;
        switch (reportingMechanism = wfReportingConfig.getReportingMechanism()) {
            case "proxy": {
                return new WavefrontProxyClient.Builder(wfReportingConfig.getProxyHost()).metricsPort(wfReportingConfig.getProxyMetricsPort()).distributionPort(wfReportingConfig.getProxyDistributionsPort()).tracingPort(wfReportingConfig.getProxyTracingPort()).build();
            }
            case "direct": {
                return new WavefrontDirectIngestionClient.Builder(wfReportingConfig.getServer(), wfReportingConfig.getToken()).build();
            }
        }
        throw new RuntimeException("Invalid reporting mechanism:" + reportingMechanism);
    }

    public static WavefrontReportingConfig constructWavefrontReportingConfig(String wfReportingConfigYamlFile) {
        YAMLParser parser;
        YAMLFactory factory = new YAMLFactory((ObjectCodec)new ObjectMapper());
        try {
            parser = factory.createParser(new File(wfReportingConfigYamlFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            return (WavefrontReportingConfig)parser.readValueAs(WavefrontReportingConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ApplicationTags constructApplicationTags(String applicationTagsYamlFile) {
        ApplicationTagsConfig applicationTagsConfig = ReportingUtils.constructApplicationTagsConfig(applicationTagsYamlFile);
        return ReportingUtils.constructApplicationTags(applicationTagsConfig);
    }

    public static ApplicationTags constructApplicationTags(ApplicationTagsConfig applicationTagsConfig) {
        ApplicationTags.Builder applicationTagsBuilder = new ApplicationTags.Builder(applicationTagsConfig.getApplication(), applicationTagsConfig.getService());
        if (applicationTagsConfig.getCluster() != null) {
            applicationTagsBuilder.cluster(applicationTagsConfig.getCluster());
        }
        if (applicationTagsConfig.getShard() != null) {
            applicationTagsBuilder.shard(applicationTagsConfig.getShard());
        }
        if (applicationTagsConfig.getCustomTags() != null) {
            applicationTagsBuilder.customTags(applicationTagsConfig.getCustomTags());
        }
        return applicationTagsBuilder.build();
    }

    public static ApplicationTagsConfig constructApplicationTagsConfig(String applicationTagsYamlFile) {
        YAMLParser parser;
        YAMLFactory factory = new YAMLFactory((ObjectCodec)new ObjectMapper());
        try {
            parser = factory.createParser(new File(applicationTagsYamlFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            return (ApplicationTagsConfig)parser.readValueAs(ApplicationTagsConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

