/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront;

import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Counter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.DeltaCounter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Gauge;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Histogram;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Meter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Timer;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.WavefrontHistogram;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.direct.ingestion.WavefrontDirectIngestionClient;
import com.wavefront.sdk.proxy.WavefrontProxyClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Main {
    public static void main(String[] args) throws InterruptedException, IOException {
        Gauge genericGauge;
        String wavefrontServer = args[0];
        String token = args[1];
        String proxyHost = args.length < 3 ? null : args[2];
        String metricsPort = args.length < 4 ? null : args[3];
        String distributionPort = args.length < 5 ? null : args[4];
        WavefrontProxyClient.Builder proxyBuilder = new WavefrontProxyClient.Builder(proxyHost);
        if (metricsPort != null) {
            proxyBuilder.metricsPort(Integer.parseInt(metricsPort));
        }
        if (distributionPort != null) {
            proxyBuilder.distributionPort(Integer.parseInt(distributionPort));
        }
        WavefrontProxyClient wavefrontProxyClient = proxyBuilder.build();
        WavefrontDirectIngestionClient wavefrontDirectIngestionClient = new WavefrontDirectIngestionClient.Builder(wavefrontServer, token).build();
        WavefrontInternalReporter.Builder builder = new WavefrontInternalReporter.Builder();
        builder.withSource("mySource");
        builder.prefixedWith("myInternal");
        HashMap<String, String> reporterTagsMap = new HashMap<String, String>(){
            {
                this.put("env", "Staging");
                this.put("location", "SF");
            }
        };
        builder.withReporterPointTags((Map<String, String>)reporterTagsMap);
        builder.withReporterPointTag("cluster", "us-west");
        builder.reportMinuteDistribution();
        builder.reportHourDistribution();
        builder.reportDayDistribution();
        WavefrontInternalReporter internalReporter = builder.build((WavefrontSender)wavefrontDirectIngestionClient);
        internalReporter.start(30L, TimeUnit.SECONDS);
        HashMap<String, String> pointTagMap = new HashMap<String, String>(){
            {
                this.put("application", "Wavefront");
            }
        };
        Counter counter = internalReporter.newCounter(new MetricName("myCounter", (Map<String, String>)pointTagMap));
        DeltaCounter deltaCounter = internalReporter.newDeltaCounter(new MetricName("myDeltaCounter", (Map<String, String>)pointTagMap));
        AtomicInteger bufferSize = new AtomicInteger();
        Gauge doubleGauge = genericGauge = internalReporter.newGauge(new MetricName("myGauge", (Map<String, String>)pointTagMap), () -> () -> (double)bufferSize.get());
        System.out.println("Current gauge value: " + doubleGauge.getValue());
        Meter meter = internalReporter.newMeter(new MetricName("myMeter", (Map<String, String>)pointTagMap));
        Timer timer = internalReporter.newTimer(new MetricName("myTimer", (Map<String, String>)pointTagMap));
        Histogram histogram = internalReporter.newHistogram(new MetricName("myHistogram", (Map<String, String>)pointTagMap));
        WavefrontHistogram wavefrontHistogram = internalReporter.newWavefrontHistogram(new MetricName("myWavefrontHistogram", (Map<String, String>)pointTagMap));
        for (int i = 0; i < 50; ++i) {
            counter.inc();
            deltaCounter.inc();
            bufferSize.set(10 * i);
            meter.mark(i);
            timer.update(i, TimeUnit.SECONDS);
            histogram.update(i);
            wavefrontHistogram.update(i);
            Thread.sleep(50L);
        }
    }
}

