/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.concurrent.aop;

import com.vladmihalcea.concurrent.Retry;
import com.vladmihalcea.util.ReflectionUtils;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

@Aspect
public class OptimisticConcurrencyControlAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptimisticConcurrencyControlAspect.class);

    @Around(value="@annotation(com.vladmihalcea.concurrent.Retry)")
    public Object retry(ProceedingJoinPoint pjp) throws Throwable {
        Retry retryAnnotation = ReflectionUtils.getAnnotation(pjp, Retry.class);
        return retryAnnotation != null ? this.proceed(pjp, retryAnnotation) : this.proceed(pjp);
    }

    private Object proceed(ProceedingJoinPoint pjp) throws Throwable {
        return pjp.proceed();
    }

    private Object proceed(ProceedingJoinPoint pjp, Retry retryAnnotation) throws Throwable {
        int times = retryAnnotation.times();
        Object[] retryOn = retryAnnotation.on();
        Assert.isTrue((times > 0 ? 1 : 0) != 0, (String)"@Retry{times} should be greater than 0!");
        Assert.isTrue((retryOn.length > 0 ? 1 : 0) != 0, (String)"@Retry{on} should have at least one Throwable!");
        if (retryAnnotation.failInTransaction() && TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new IllegalTransactionStateException("You shouldn't retry an operation from within an existing Transaction.This is because we can't retry if the current Transaction was already rolled back!");
        }
        LOGGER.info("Proceed with {} retries on {}", (Object)times, (Object)Arrays.toString(retryOn));
        return this.tryProceeding(pjp, times, (Class<? extends Throwable>[])retryOn);
    }

    private Object tryProceeding(ProceedingJoinPoint pjp, int times, Class<? extends Throwable>[] retryOn) throws Throwable {
        try {
            return this.proceed(pjp);
        }
        catch (Throwable throwable) {
            if (this.isRetryThrowable(throwable, retryOn) && times-- > 0) {
                LOGGER.info("Optimistic locking detected, {} remaining retr{} on {}", new Object[]{times, times == 1 ? "y" : "ies", Arrays.toString(retryOn)});
                return this.tryProceeding(pjp, times, retryOn);
            }
            throw throwable;
        }
    }

    private boolean isRetryThrowable(Throwable throwable, Class<? extends Throwable>[] retryOn) {
        Throwable cause = throwable;
        while (true) {
            for (Class<? extends Throwable> retryThrowable : retryOn) {
                if (!retryThrowable.isAssignableFrom(cause.getClass())) continue;
                return true;
            }
            if (cause.getCause() == null || cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }
}

