/*
 * Decompiled with CFR 0.152.
 */
package com.vincenzoracca.webflux.mdc.util;

import io.micrometer.context.ContextRegistry;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.MDC;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class MDCUtil {
    private MDCUtil() {
    }

    public static <T> Mono<T> wrapMDC(Mono<T> mono, Map<String, Object> mdcMap) {
        mdcMap.forEach((key, value) -> MDCUtil.registerMDC(key));
        return Mono.defer(() -> mono.contextWrite((ContextView)Context.of((Map)mdcMap)));
    }

    public static <T> Mono<T> wrapMDC(Mono<T> mono, String mdcKey, String mdcValue) {
        MDCUtil.registerMDC(mdcKey);
        return Mono.defer(() -> mono.contextWrite((ContextView)Context.of((Object)mdcKey, (Object)mdcValue)));
    }

    public static <T> Flux<T> wrapMDC(Flux<T> flux, Map<String, Object> mdcMap) {
        mdcMap.forEach((key, value) -> MDCUtil.registerMDC(key));
        return Flux.defer(() -> flux.contextWrite((ContextView)Context.of((Map)mdcMap)));
    }

    public static <T> Flux<T> wrapMDC(Flux<T> flux, String mdcKey, String mdcValue) {
        MDCUtil.registerMDC(mdcKey);
        return Flux.defer(() -> flux.contextWrite((ContextView)Context.of((Object)mdcKey, (Object)mdcValue)));
    }

    public static void registerMDC(String mdcKey) {
        Supplier<String> getMDC = () -> MDC.get((String)mdcKey);
        Consumer<String> putMDC = value -> MDC.put((String)mdcKey, (String)value);
        Runnable removeMDC = () -> MDC.remove((String)mdcKey);
        ContextRegistry.getInstance().registerThreadLocalAccessor(mdcKey, getMDC, putMDC, removeMDC);
    }
}

