/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.offset;

import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffsetKind;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.util.Preconditions;

public class BinlogOffsetBuilder {
    private final Map<String, String> offsetMap = new HashMap<String, String>();

    public BinlogOffsetBuilder() {
        this.offsetMap.put("event", "0");
        this.offsetMap.put("row", "0");
        this.offsetMap.put("ts_sec", "0");
        this.offsetMap.put("kind", String.valueOf((Object)BinlogOffsetKind.SPECIFIC));
    }

    public BinlogOffsetBuilder setBinlogFilePosition(String filename, long position) {
        this.offsetMap.put("file", filename);
        this.offsetMap.put("pos", String.valueOf(position));
        return this;
    }

    public BinlogOffsetBuilder setSkipEvents(long skipEvents) {
        this.offsetMap.put("event", String.valueOf(skipEvents));
        return this;
    }

    public BinlogOffsetBuilder setSkipRows(long skipRows) {
        this.offsetMap.put("row", String.valueOf(skipRows));
        return this;
    }

    public BinlogOffsetBuilder setTimestampSec(long timestampSec) {
        this.offsetMap.put("ts_sec", String.valueOf(timestampSec));
        return this;
    }

    public BinlogOffsetBuilder setGtidSet(String gtidSet) {
        this.offsetMap.put("gtids", gtidSet);
        return this;
    }

    public BinlogOffsetBuilder setServerId(long serverId) {
        this.offsetMap.put("server_id", String.valueOf(serverId));
        return this;
    }

    public BinlogOffsetBuilder setOffsetKind(BinlogOffsetKind offsetKind) {
        this.offsetMap.put("kind", String.valueOf((Object)offsetKind));
        if (offsetKind == BinlogOffsetKind.EARLIEST) {
            this.setBinlogFilePosition("", 0L);
        }
        if (offsetKind == BinlogOffsetKind.NON_STOPPING) {
            this.setBinlogFilePosition("", Long.MIN_VALUE);
        }
        return this;
    }

    public BinlogOffsetBuilder setOffsetMap(Map<String, String> offsetMap) {
        this.offsetMap.putAll(offsetMap);
        return this;
    }

    public BinlogOffset build() {
        this.sanityCheck();
        return new BinlogOffset(this.offsetMap);
    }

    private void sanityCheck() {
        Preconditions.checkArgument((boolean)this.offsetMap.containsKey("kind"), (Object)"Binlog offset kind is required");
        BinlogOffsetKind offsetKind = BinlogOffsetKind.valueOf(this.offsetMap.get("kind"));
        switch (offsetKind) {
            case SPECIFIC: {
                Preconditions.checkArgument((this.offsetMap.containsKey("file") || this.offsetMap.containsKey("pos") || this.offsetMap.containsKey("gtids") ? 1 : 0) != 0, (Object)"Either binlog file / position or GTID set is required if offset kind is SPECIFIC");
                break;
            }
            case TIMESTAMP: {
                Preconditions.checkArgument((boolean)this.offsetMap.containsKey("ts_sec"));
                break;
            }
            case EARLIEST: 
            case LATEST: 
            case NON_STOPPING: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unrecognized offset kind \"%s\"", new Object[]{offsetKind}));
            }
        }
    }
}

