/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.enumerator;

import com.ververica.cdc.connectors.mysql.source.assigners.AssignerStatus;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlBinlogSplitAssigner;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlHybridSplitAssigner;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlSplitAssigner;
import com.ververica.cdc.connectors.mysql.source.assigners.state.PendingSplitsState;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.mysql.source.events.BinlogSplitAssignedEvent;
import com.ververica.cdc.connectors.mysql.source.events.BinlogSplitMetaEvent;
import com.ververica.cdc.connectors.mysql.source.events.BinlogSplitMetaRequestEvent;
import com.ververica.cdc.connectors.mysql.source.events.BinlogSplitUpdateAckEvent;
import com.ververica.cdc.connectors.mysql.source.events.BinlogSplitUpdateRequestEvent;
import com.ververica.cdc.connectors.mysql.source.events.FinishedSnapshotSplitsAckEvent;
import com.ververica.cdc.connectors.mysql.source.events.FinishedSnapshotSplitsReportEvent;
import com.ververica.cdc.connectors.mysql.source.events.FinishedSnapshotSplitsRequestEvent;
import com.ververica.cdc.connectors.mysql.source.events.LatestFinishedSplitsNumberEvent;
import com.ververica.cdc.connectors.mysql.source.events.LatestFinishedSplitsNumberRequestEvent;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MySqlSourceEnumerator
implements SplitEnumerator<MySqlSplit, PendingSplitsState> {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSourceEnumerator.class);
    private static final long CHECK_EVENT_INTERVAL = 30000L;
    private final SplitEnumeratorContext<MySqlSplit> context;
    private final MySqlSourceConfig sourceConfig;
    private final MySqlSplitAssigner splitAssigner;
    private final TreeSet<Integer> readersAwaitingSplit;
    private List<List<FinishedSnapshotSplitInfo>> binlogSplitMeta;
    @Nullable
    private Integer binlogSplitTaskId;

    public MySqlSourceEnumerator(SplitEnumeratorContext<MySqlSplit> context, MySqlSourceConfig sourceConfig, MySqlSplitAssigner splitAssigner) {
        this.context = context;
        this.sourceConfig = sourceConfig;
        this.splitAssigner = splitAssigner;
        this.readersAwaitingSplit = new TreeSet();
    }

    public void start() {
        this.splitAssigner.open();
        this.requestBinlogSplitUpdateIfNeed();
        this.context.callAsync(this::getRegisteredReader, this::syncWithReaders, 30000L, 30000L);
    }

    public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
        if (!this.context.registeredReaders().containsKey(subtaskId)) {
            return;
        }
        this.readersAwaitingSplit.add(subtaskId);
        this.assignSplits();
    }

    public void addSplitsBack(List<MySqlSplit> splits, int subtaskId) {
        LOG.debug("The enumerator adds splits back: {}", splits);
        Optional<MySqlSplit> binlogSplit = splits.stream().filter(MySqlSplit::isBinlogSplit).findAny();
        if (binlogSplit.isPresent()) {
            LOG.info("The enumerator adds add binlog split back: {}", binlogSplit);
            this.binlogSplitTaskId = null;
        }
        this.splitAssigner.addSplits(splits);
    }

    public void addReader(int subtaskId) {
        if (AssignerStatus.isNewlyAddedAssigningSnapshotFinished(this.splitAssigner.getAssignerStatus())) {
            this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new BinlogSplitUpdateRequestEvent());
        }
    }

    public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
        if (sourceEvent instanceof FinishedSnapshotSplitsReportEvent) {
            LOG.info("The enumerator under {} receives finished split offsets {} from subtask {}.", new Object[]{this.splitAssigner.getAssignerStatus(), sourceEvent, subtaskId});
            FinishedSnapshotSplitsReportEvent reportEvent = (FinishedSnapshotSplitsReportEvent)sourceEvent;
            Map<String, BinlogOffset> finishedOffsets = reportEvent.getFinishedOffsets();
            this.splitAssigner.onFinishedSplits(finishedOffsets);
            this.requestBinlogSplitUpdateIfNeed();
            FinishedSnapshotSplitsAckEvent ackEvent = new FinishedSnapshotSplitsAckEvent(new ArrayList<String>(finishedOffsets.keySet()));
            this.context.sendEventToSourceReader(subtaskId, (SourceEvent)ackEvent);
        } else if (sourceEvent instanceof BinlogSplitMetaRequestEvent) {
            LOG.debug("The enumerator receives request for binlog split meta from subtask {}.", (Object)subtaskId);
            this.sendBinlogMeta(subtaskId, (BinlogSplitMetaRequestEvent)sourceEvent);
        } else if (sourceEvent instanceof BinlogSplitUpdateAckEvent) {
            LOG.info("The enumerator receives event that the binlog split has been updated from subtask {}. ", (Object)subtaskId);
            this.splitAssigner.onBinlogSplitUpdated();
        } else if (sourceEvent instanceof LatestFinishedSplitsNumberRequestEvent) {
            LOG.info("The enumerator receives request from subtask {} for the latest finished splits number after added newly tables. ", (Object)subtaskId);
            this.handleLatestFinishedSplitNumberRequest(subtaskId);
        } else if (sourceEvent instanceof BinlogSplitAssignedEvent) {
            LOG.info("The enumerator receives notice from subtask {} for the binlog split assignment. ", (Object)subtaskId);
            this.binlogSplitTaskId = subtaskId;
        }
    }

    public PendingSplitsState snapshotState(long checkpointId) {
        return this.splitAssigner.snapshotState(checkpointId);
    }

    public void notifyCheckpointComplete(long checkpointId) {
        this.splitAssigner.notifyCheckpointComplete(checkpointId);
        this.assignSplits();
    }

    public void close() {
        LOG.info("Closing enumerator...");
        this.splitAssigner.close();
    }

    private void assignSplits() {
        Iterator<Integer> awaitingReader = this.readersAwaitingSplit.iterator();
        while (awaitingReader.hasNext()) {
            int nextAwaiting = awaitingReader.next();
            if (!this.context.registeredReaders().containsKey(nextAwaiting)) {
                awaitingReader.remove();
                continue;
            }
            if (this.splitAssigner.isStreamSplitAssigned() && this.sourceConfig.isCloseIdleReaders() && this.noMoreSnapshotSplits() && this.binlogSplitTaskId != null && !this.binlogSplitTaskId.equals(nextAwaiting)) {
                this.context.signalNoMoreSplits(nextAwaiting);
                awaitingReader.remove();
                LOG.info("Close idle reader of subtask {}", (Object)nextAwaiting);
                continue;
            }
            Optional<MySqlSplit> split = this.splitAssigner.getNext();
            if (split.isPresent()) {
                MySqlSplit mySqlSplit = split.get();
                this.context.assignSplit((SourceSplit)mySqlSplit, nextAwaiting);
                if (mySqlSplit instanceof MySqlBinlogSplit) {
                    this.binlogSplitTaskId = nextAwaiting;
                }
                awaitingReader.remove();
                LOG.info("The enumerator assigns split {} to subtask {}", (Object)mySqlSplit, (Object)nextAwaiting);
                continue;
            }
            this.requestBinlogSplitUpdateIfNeed();
            break;
        }
    }

    private boolean noMoreSnapshotSplits() {
        if (this.splitAssigner instanceof MySqlHybridSplitAssigner) {
            return ((MySqlHybridSplitAssigner)this.splitAssigner).noMoreSnapshotSplits();
        }
        if (this.splitAssigner instanceof MySqlBinlogSplitAssigner) {
            return true;
        }
        throw new IllegalStateException("Unexpected subtype of MySqlSplitAssigner class when invoking noMoreSnapshotSplits.");
    }

    private int[] getRegisteredReader() {
        return this.context.registeredReaders().keySet().stream().mapToInt(Integer::intValue).toArray();
    }

    private void syncWithReaders(int[] subtaskIds, Throwable t) {
        if (t != null) {
            throw new FlinkRuntimeException("Failed to list obtain registered readers due to:", t);
        }
        if (this.splitAssigner.waitingForFinishedSplits()) {
            for (int subtaskId : subtaskIds) {
                this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new FinishedSnapshotSplitsRequestEvent());
            }
        }
        this.requestBinlogSplitUpdateIfNeed();
    }

    private void requestBinlogSplitUpdateIfNeed() {
        if (AssignerStatus.isNewlyAddedAssigningSnapshotFinished(this.splitAssigner.getAssignerStatus())) {
            for (int subtaskId : this.getRegisteredReader()) {
                LOG.info("The enumerator requests subtask {} to update the binlog split after newly added table.", (Object)subtaskId);
                this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new BinlogSplitUpdateRequestEvent());
            }
        }
    }

    private void sendBinlogMeta(int subTask, BinlogSplitMetaRequestEvent requestEvent) {
        if (this.binlogSplitMeta == null) {
            List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos = this.splitAssigner.getFinishedSplitInfos();
            if (finishedSnapshotSplitInfos.isEmpty()) {
                LOG.error("The assigner offers empty finished split information, this should not happen");
                throw new FlinkRuntimeException("The assigner offers empty finished split information, this should not happen");
            }
            this.binlogSplitMeta = Lists.partition(finishedSnapshotSplitInfos, (int)this.sourceConfig.getSplitMetaGroupSize());
        }
        int requestMetaGroupId = requestEvent.getRequestMetaGroupId();
        if (this.binlogSplitMeta.size() > requestMetaGroupId) {
            List<FinishedSnapshotSplitInfo> metaToSend = this.binlogSplitMeta.get(requestMetaGroupId);
            BinlogSplitMetaEvent metadataEvent = new BinlogSplitMetaEvent(requestEvent.getSplitId(), requestMetaGroupId, metaToSend.stream().map(FinishedSnapshotSplitInfo::serialize).collect(Collectors.toList()));
            this.context.sendEventToSourceReader(subTask, (SourceEvent)metadataEvent);
        } else {
            LOG.error("The enumerator received invalid request meta group id {}, the valid meta group id range is [0, {}]", (Object)requestMetaGroupId, (Object)(this.binlogSplitMeta.size() - 1));
        }
    }

    private void handleLatestFinishedSplitNumberRequest(int subTask) {
        if (this.splitAssigner instanceof MySqlHybridSplitAssigner) {
            this.context.sendEventToSourceReader(subTask, (SourceEvent)new LatestFinishedSplitsNumberEvent(this.splitAssigner.getFinishedSplitInfos().size()));
        }
    }
}

