/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.connection;

import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.mysql.source.connection.ConnectionPoolId;
import com.ververica.cdc.connectors.mysql.source.connection.ConnectionPools;
import com.ververica.cdc.connectors.mysql.source.connection.PooledDataSourceFactory;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionPools
implements ConnectionPools {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcConnectionPools.class);
    private static final JdbcConnectionPools INSTANCE = new JdbcConnectionPools();
    private final Map<ConnectionPoolId, HikariDataSource> pools = new HashMap<ConnectionPoolId, HikariDataSource>();

    private JdbcConnectionPools() {
    }

    public static JdbcConnectionPools getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HikariDataSource getOrCreateConnectionPool(ConnectionPoolId poolId, MySqlSourceConfig sourceConfig) {
        Map<ConnectionPoolId, HikariDataSource> map = this.pools;
        synchronized (map) {
            if (!this.pools.containsKey(poolId)) {
                LOG.info("Create and register connection pool {}", (Object)poolId);
                this.pools.put(poolId, PooledDataSourceFactory.createPooledDataSource(sourceConfig));
            }
            return this.pools.get(poolId);
        }
    }
}

