/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.license3j.licensor;

import com.javax0.license3j.licensor.encrypt.PGPHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.Properties;
import java.util.stream.Stream;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.jcajce.JcaPGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;

public class License {
    private static final String DEFAULT_CHARSET = "utf-8";
    private final PGPHelper cryptor = new PGPHelper();
    private Properties licenseProperties = null;
    private boolean verified = false;
    private byte[] publicKeyRing = null;
    private Long decodeKeyId = null;

    private static <T> Iterable<T> in(Iterator<T> iterator) {
        return () -> iterator;
    }

    private static Iterable<String> inS(Iterator iterator) {
        return () -> iterator;
    }

    private static void notNull(Object o) throws PGPException {
        if (o == null) {
            throw new PGPException("can not decode");
        }
    }

    @Deprecated
    public static String fromResource(String resourceName) {
        return License.class.getClassLoader().getResource(resourceName).getFile();
    }

    public Stream<String> features() {
        return this.licenseProperties.keySet().stream().map(s -> (String)s);
    }

    public License setFeature(String key, String value) {
        if (this.licenseProperties == null) {
            this.licenseProperties = new Properties();
        }
        this.licenseProperties.put(key, value);
        return this;
    }

    public String getFeature(String key) {
        String feature = this.licenseProperties != null && this.licenseProperties.containsKey(key) ? this.licenseProperties.getProperty(key) : null;
        return feature;
    }

    @Deprecated
    public void setLicense(InputStream is) throws IOException {
        this.verified = false;
        this.licenseProperties = new Properties();
        this.licenseProperties.load(is);
    }

    public void setLicense(InputStream is, String charset) throws IOException {
        this.verified = false;
        this.licenseProperties = new Properties();
        this.licenseProperties.load(new InputStreamReader(is, charset));
    }

    @Deprecated
    public License setLicense(File file) throws IOException {
        this.setLicense(new FileInputStream(file));
        return this;
    }

    public License setLicense(File file, String charset) throws IOException {
        this.setLicense(new FileInputStream(file), charset);
        return this;
    }

    public License setLicense(String licenseString) throws IOException {
        this.setLicense(new ByteArrayInputStream(licenseString.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET);
        return this;
    }

    public String getLicenseString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.licenseProperties != null) {
                this.licenseProperties.store(baos, "-- license file");
            }
            baos.close();
            String loadedLicense = new String(baos.toByteArray());
            return loadedLicense.replaceAll("\r\n", "\n");
        }
        catch (IOException ex) {
            return "";
        }
    }

    public void dumpLicense(String fileName) throws IOException {
        this.dumpLicense(new File(fileName));
    }

    public void dumpLicense(File file) throws IOException {
        this.dumpLicense(new FileOutputStream(file));
    }

    public void dumpLicense(OutputStream os) throws IOException {
        if (this.licenseProperties != null) {
            this.licenseProperties.store(os, "");
        }
    }

    public boolean isVerified() {
        return this.verified;
    }

    public License setHashAlgorithm(int hashAlgorithm) {
        this.cryptor.setHashAlgorithm(hashAlgorithm);
        return this;
    }

    public License loadKey(String fn, String keyId) throws IOException, PGPException {
        this.loadKey(new File(fn), keyId);
        return this;
    }

    public License loadKeyRingFromResource(String resourceName, byte[] digest) throws IOException {
        return this.loadKeyRing(this.getClass().getClassLoader().getResourceAsStream(resourceName), digest);
    }

    public License loadKeyRing(String fileName, byte[] digest) throws IOException {
        this.loadKeyRing(new File(fileName), digest);
        return this;
    }

    public License loadKeyRing(File file, byte[] digest) throws IOException {
        this.loadKeyRing(new FileInputStream(file), digest);
        return this;
    }

    public License loadKeyRing(InputStream in, byte[] digest) throws IOException {
        int ch;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((ch = in.read()) >= 0) {
            baos.write(ch);
        }
        this.publicKeyRing = baos.toByteArray();
        if (digest != null) {
            byte[] calculatedDigest = this.calculatePublicKeyRingDigest();
            for (int i = 0; i < calculatedDigest.length; ++i) {
                if (calculatedDigest[i] == digest[i]) continue;
                this.publicKeyRing = null;
                throw new IllegalArgumentException("Key ring digest does not match.");
            }
        }
        return this;
    }

    public byte[] calculatePublicKeyRingDigest() {
        SHA512Digest dig = new SHA512Digest();
        dig.reset();
        dig.update(this.publicKeyRing, 0, this.publicKeyRing.length);
        byte[] digest = new byte[dig.getDigestSize()];
        dig.doFinal(digest, 0);
        return digest;
    }

    public String dumpPublicKeyRingDigest() {
        byte[] calculatedDigest = this.calculatePublicKeyRingDigest();
        StringBuilder retval = new StringBuilder("byte [] digest = new byte[] {\n");
        for (int i = 0; i < calculatedDigest.length; ++i) {
            int intVal = calculatedDigest[i] & 0xFF;
            retval.append(String.format("(byte)0x%02X, ", intVal));
            if (i % 8 != 0) continue;
            retval.append("\n");
        }
        retval.append("\n};\n");
        return retval.toString();
    }

    public License loadKey(File fin, String user) throws IOException, PGPException {
        this.loadKey(new FileInputStream(fin), user);
        return this;
    }

    public License loadKey(InputStream keyRing, String user) throws IOException, PGPException {
        InputStream decoder = PGPUtil.getDecoderStream((InputStream)keyRing);
        JcaPGPSecretKeyRingCollection keyRingCollection = new JcaPGPSecretKeyRingCollection(decoder);
        for (PGPSecretKeyRing ring : License.in(keyRingCollection.getKeyRings())) {
            for (PGPSecretKey key : License.in(ring.getSecretKeys())) {
                for (String keyUserId : License.inS(key.getUserIDs())) {
                    if (!PGPHelper.keyIsAppropriate(key, user, keyUserId)) continue;
                    this.cryptor.setKey(key);
                    return this;
                }
            }
        }
        throw new IllegalArgumentException("Can't find signing key in key ring.");
    }

    public String encodeLicense(String keyPassPhraseString) throws IOException, PGPException {
        String licensePlain = this.getLicenseString();
        return new String(this.cryptor.encodeLicense(keyPassPhraseString, licensePlain), DEFAULT_CHARSET);
    }

    public License setLicenseEncoded(String license) throws IOException, PGPException {
        try {
            this.setLicenseEncoded(new ByteArrayInputStream(license.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException shouldNotEverHappen) {
            throw new RuntimeException(shouldNotEverHappen);
        }
        return this;
    }

    @Deprecated
    public License setLicenseEncodedFromResource(String resourceName) throws IOException, PGPException {
        this.setLicenseEncoded(License.class.getClassLoader().getResourceAsStream(resourceName));
        return this;
    }

    public License setLicenseEncodedFromResource(String resourceName, String charset) throws IOException, PGPException {
        this.setLicenseEncoded(License.class.getClassLoader().getResourceAsStream(resourceName), charset);
        return this;
    }

    @Deprecated
    public License setLicenseEncodedFromFile(String fileName) throws IOException, PGPException {
        this.setLicenseEncodedFromFile(fileName, null);
        return this;
    }

    public License setLicenseEncodedFromFile(String fileName, String charset) throws IOException, PGPException {
        this.setLicenseEncoded(new File(fileName), charset);
        return this;
    }

    @Deprecated
    public void setLicenseEncodedFromFile(File file) throws IOException, PGPException {
        this.setLicenseEncoded(file);
    }

    @Deprecated
    public void setLicenseEncoded(File file) throws IOException, PGPException {
        this.setLicenseEncoded(file, null);
    }

    public void setLicenseEncoded(File file, String charset) throws IOException, PGPException {
        this.setLicenseEncoded(new FileInputStream(file), charset);
    }

    public Long getDecodeKeyId() {
        return this.decodeKeyId;
    }

    @Deprecated
    public void setLicenseEncoded(InputStream inputStream) throws IOException, PGPException {
        this.setLicenseEncoded(inputStream, null);
    }

    public License setLicenseEncoded(InputStream inputStream, String charset) throws IOException, PGPException {
        ByteArrayInputStream keyIn = new ByteArrayInputStream(this.publicKeyRing);
        InputStream decoderInputStream = PGPUtil.getDecoderStream((InputStream)inputStream);
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(decoderInputStream);
        PGPCompressedData c1 = (PGPCompressedData)pgpFact.nextObject();
        License.notNull(c1);
        pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
        PGPOnePassSignatureList p1 = (PGPOnePassSignatureList)pgpFact.nextObject();
        License.notNull(p1);
        PGPOnePassSignature ops = p1.get(0);
        PGPLiteralData p2 = (PGPLiteralData)pgpFact.nextObject();
        License.notNull(p2);
        InputStream dIn = p2.getInputStream();
        License.notNull(dIn);
        BcPGPPublicKeyRingCollection pgpRing = new BcPGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyIn));
        License.notNull(ops);
        this.decodeKeyId = ops.getKeyID();
        PGPPublicKey decodeKey = pgpRing.getPublicKey(this.decodeKeyId.longValue());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int ch;
            JcaPGPContentVerifierBuilderProvider cvBuilder = new JcaPGPContentVerifierBuilderProvider();
            ops.init((PGPContentVerifierBuilderProvider)cvBuilder, decodeKey);
            while ((ch = dIn.read()) >= 0) {
                ops.update((byte)ch);
                out.write(ch);
            }
            PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
            if (ops.verify(p3.get(0))) {
                if (charset == null) {
                    this.setLicense(new String(out.toByteArray()));
                } else {
                    this.setLicense(new String(out.toByteArray(), charset));
                }
                this.verified = true;
            } else {
                this.verified = false;
                this.licenseProperties = null;
            }
        }
        catch (Exception e) {
            this.verified = false;
            this.licenseProperties = null;
        }
        return this;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

