/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.license3j;

import com.javax0.license3j.licensor.License;
import com.javax0.license3j.utils.CommandLineProcessor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class License3j {
    private static final String commandLineString = "java -cp license3j.jar com.javax0.license3j.License3j";
    static PrintStream errorOutput = System.err;
    private static CommandLineProcessor commandLine;

    private static void printUsage(String[] args) {
        errorOutput.print("Usage: java -cp license3j.jar com.javax0.license3j.License3j decode options\n mandatory options are: \n--license-file, --keyring-file, [ --output ] [--charset]\n");
        errorOutput.println("Usage: java -cp license3j.jar com.javax0.license3j.License3j command options\ncommands available: \n      * encode\n      * decode\narguments to the different commands type the command w/o args");
        if (args != null) {
            errorOutput.println("Arguments on the command line:");
            int i = 1;
            for (String arg : args) {
                errorOutput.println(i + ". " + arg);
                ++i;
            }
            errorOutput.println("Command line options:");
            i = 1;
            for (String opt : commandLine.getOptions().keySet()) {
                errorOutput.println(i + ". option[" + opt + "]=" + commandLine.option(opt));
                ++i;
            }
        }
        errorOutput.println("Current working directory " + System.getProperties().get("user.dir"));
    }

    public static void main(String[] args) throws Exception {
        commandLine = new CommandLineProcessor();
        if (args == null || args.length == 0) {
            License3j.printUsage(args);
            return;
        }
        commandLine.process(args);
        if (commandLine.getFiles().size() < 1) {
            License3j.printUsage(args);
            return;
        }
        String command = commandLine.getFiles().get(0);
        if ("encode".equals(command)) {
            new License3j().encode();
        }
        if ("decode".equals(command)) {
            new License3j().decode();
        }
    }

    private void encode() throws Exception {
        try {
            FileOutputStream os = new FileOutputStream(commandLine.option("output"));
            os.write(new License().setLicense(new File(commandLine.option("license-file")), "utf-8").loadKey(commandLine.option("keyring-file"), commandLine.option("key")).encodeLicense(commandLine.option("password")).getBytes("utf-8"));
            os.close();
        }
        catch (Exception e) {
            errorOutput.print("Usage: java -cp license3j.jar com.javax0.license3j.License3j encode options\n mandatory options are: \n--license-file, --keyring-file, --key, --password, --output\n");
            throw e;
        }
    }

    private void decode() throws Exception {
        block15: {
            try {
                License license = new License();
                if (license.loadKeyRing(commandLine.option("keyring-file"), null).setLicenseEncodedFromFile(commandLine.option("license-file"), "utf-8").isVerified()) {
                    try (OutputStream os = this.getOutput();
                         Writer w = this.getOutputWriter(os);){
                        w.write("---LICENSE STRING PLAIN TEXT START\n");
                        w.flush();
                        license.dumpLicense(os);
                        w.write("---LICENSE STRING PLAIN TEXT END\n");
                        w.write("Encoding license key id=" + license.getDecodeKeyId() + "L\n");
                        w.write("---KEY RING DIGEST START\n");
                        w.write(license.dumpPublicKeyRingDigest());
                        w.write("---KEY RING DIGEST END\n");
                        break block15;
                    }
                }
                errorOutput.println("The license can not be verified.");
            }
            catch (Exception e) {
                License3j.printUsage(null);
                e.printStackTrace(errorOutput);
                throw e;
            }
        }
    }

    private Writer getOutputWriter(OutputStream os) throws UnsupportedEncodingException {
        if (commandLine.optionExists("charset").booleanValue()) {
            return new OutputStreamWriter(os, commandLine.option("charset"));
        }
        return new OutputStreamWriter(os);
    }

    private OutputStream getOutput() throws FileNotFoundException {
        if (commandLine.optionExists("output").booleanValue()) {
            return new FileOutputStream(commandLine.option("output"));
        }
        return System.out;
    }
}

