/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.internal;

import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringBeanUtil {
    private SpringBeanUtil() {
    }

    public static <T> T createManagedBeanIfAvailable(ApplicationContext applicationContext, Class<T> cls) {
        String[] beanNames;
        for (String beanName : beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)applicationContext, cls)) {
            if (applicationContext.getAutowireCapableBeanFactory().getType(beanName) != cls) continue;
            return (T)applicationContext.getBean(cls);
        }
        return null;
    }
}

