/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.theme.lumo;

import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.theme.AbstractTheme;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

@HtmlImport.Container(value={@HtmlImport(value="frontend://bower_components/vaadin-lumo-styles/color.html"), @HtmlImport(value="frontend://bower_components/vaadin-lumo-styles/typography.html"), @HtmlImport(value="frontend://bower_components/vaadin-lumo-styles/sizing.html"), @HtmlImport(value="frontend://bower_components/vaadin-lumo-styles/spacing.html"), @HtmlImport(value="frontend://bower_components/vaadin-lumo-styles/style.html"), @HtmlImport(value="frontend://bower_components/vaadin-lumo-styles/icons.html")})
public class Lumo
implements AbstractTheme {
    public static final String LIGHT = "light";
    public static final String DARK = "dark";

    public String getBaseUrl() {
        return "src/";
    }

    public String getThemeUrl() {
        return "theme/lumo/";
    }

    public List<String> getHeaderInlineContents() {
        return Collections.singletonList("<custom-style>    <style include=\"lumo-color lumo-typography\"></style></custom-style>");
    }

    public Map<String, String> getBodyAttributes(String variant) {
        if (variant.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        switch (variant) {
            case "light": {
                attributes.put("theme", LIGHT);
                break;
            }
            case "dark": {
                attributes.put("theme", DARK);
                break;
            }
            default: {
                LoggerFactory.getLogger((String)Lumo.class.getName()).warn("Lumo theme variant not recognized: '{0}'. Using no variant.", (Object)variant);
            }
        }
        return attributes;
    }
}

