/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItemBase;
import com.vaadin.flow.component.contextmenu.SubMenuBase;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.stream.Stream;

public class MenuItemsArrayGenerator<I extends MenuItemBase<?, I, ?>>
implements Serializable {
    private Component menu;
    private boolean updateScheduled = false;
    private final Element container;

    public MenuItemsArrayGenerator(Component menu) {
        this.menu = menu;
        this.container = new Element("div");
        this.getElement().appendVirtualChild(new Element[]{this.container});
        menu.getUI().ifPresent(this::addContextMenuDependencies);
        menu.addAttachListener((ComponentEventListener & Serializable)e -> this.addContextMenuDependencies(e.getUI()));
    }

    public void generate() {
        if (this.updateScheduled) {
            return;
        }
        this.updateScheduled = true;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            this.container.removeAllChildren();
            this.getItems().forEach(this::resetContainers);
            int containerNodeId = this.createNewContainer(this.menu.getChildren());
            this.getElement().callJsFunction("$connector.generateItems", new Object[]{containerNodeId});
            this.updateScheduled = false;
        });
    }

    private void resetContainers(MenuItemBase<?, I, ?> menuItem) {
        if (!menuItem.isParentItem()) {
            menuItem.getElement().removeProperty("_containerNodeId");
            return;
        }
        Object subMenu = menuItem.getSubMenu();
        int containerNodeId = this.createNewContainer(((SubMenuBase)subMenu).getChildren());
        menuItem.getElement().setProperty("_containerNodeId", (double)containerNodeId);
        ((SubMenuBase)subMenu).getItems().stream().forEach(this::resetContainers);
    }

    private int createNewContainer(Stream<Component> components) {
        Element subContainer = new Element("div");
        this.container.appendChild(new Element[]{subContainer});
        components.forEach(child -> subContainer.appendChild(new Element[]{child.getElement()}));
        return subContainer.getNode().getId();
    }

    private Stream<MenuItemBase> getItems() {
        return this.menu.getChildren().filter(MenuItemBase.class::isInstance).map(MenuItemBase.class::cast);
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(this.menu, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private Element getElement() {
        return this.menu.getElement();
    }

    private void addContextMenuDependencies(UI ui) {
        ui.getInternals().addComponentDependencies(ContextMenu.class);
    }
}

