/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $
//  type=root


/**
 * Localized names for the "fil" locale.
 */
public class LocalizedNamesImpl_fil extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "PH",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AX",
        "AL",
        "DE",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BQ",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "KY",
        "CF",
        "EA",
        "TD",
        "CL",
        "CN",
        "CX",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CK",
        "CR",
        "CI",
        "HR",
        "CU",
        "CW",
        "CY",
        "CZ",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EC",
        "EG",
        "SV",
        "GQ",
        "ER",
        "ES",
        "US",
        "EE",
        "ET",
        "EU",
        "FK",
        "FO",
        "FJ",
        "FI",
        "FR",
        "GF",
        "PF",
        "TF",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GR",
        "GL",
        "GD",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "HU",
        "IS",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KI",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MW",
        "QO",
        "MY",
        "MV",
        "ML",
        "MT",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "UM",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NL",
        "AN",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NU",
        "NF",
        "MP",
        "KP",
        "NO",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "RE",
        "RO",
        "RU",
        "RW",
        "BL",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "CS",
        "SC",
        "SL",
        "SG",
        "SK",
        "SI",
        "SB",
        "SO",
        "ZA",
        "GS",
        "KR",
        "LK",
        "SS",
        "SH",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "SX",
        "SY",
        "TW",
        "TJ",
        "TZ",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "VI",
        "UG",
        "UA",
        "AE",
        "GB",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "EH",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mundo");
    namesMap.put("011", "Kanlurang Africa");
    namesMap.put("013", "Gitnang Amerika");
    namesMap.put("014", "Silangang Africa");
    namesMap.put("015", "Hilagang Africa");
    namesMap.put("017", "Gitnang Africa");
    namesMap.put("018", "Katimugang Africa");
    namesMap.put("021", "Hilagang Amerika");
    namesMap.put("029", "Carribbean");
    namesMap.put("030", "Silangang Asya");
    namesMap.put("034", "Katimugang Asya");
    namesMap.put("035", "Timog-Silangang Asya");
    namesMap.put("039", "Katimugang Europa");
    namesMap.put("053", "Australia at New Zealand");
    namesMap.put("057", "Rehiyong Micronesia");
    namesMap.put("142", "Asya");
    namesMap.put("143", "Gitnang Asya");
    namesMap.put("145", "Kanlurang Asya");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Silangang Europa");
    namesMap.put("154", "Hilagang Europa");
    namesMap.put("155", "Kanlurang Europa");
    namesMap.put("AC", "Acsencion island");
    namesMap.put("AQ", "Antartica");
    namesMap.put("AX", "Aland Islands");
    namesMap.put("CD", "Congo - Kinshasa");
    namesMap.put("CI", "Côte d'Ivoire");
    namesMap.put("CS", "Serbia at Montenegro");
    namesMap.put("DE", "Alemanya");
    namesMap.put("ES", "Espanya");
    namesMap.put("FK", "Falkland Islands");
    namesMap.put("GS", "South Georgia and The South Sandwich Islands");
    namesMap.put("IC", "Canary Island");
    namesMap.put("IT", "Italya");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("PH", "Pilipinas");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestinian Territory");
    namesMap.put("QO", "Malayong bahagi ng Oceania");
    namesMap.put("RU", "Russian Federation");
    namesMap.put("SH", "St. Helena");
    namesMap.put("SJ", "Svalbard and Jan Mayen Islands");
    namesMap.put("ST", "Sao Tome and Principe");
    namesMap.put("TA", "Tristan de Cunha");
    namesMap.put("UM", "Mga Minor Outlying Island ng Estados Unidos");
    namesMap.put("US", "Estados Unidos");
    namesMap.put("WF", "Wallis and the Futuna Islands");
    namesMap.put("ZZ", "Hindi kilala o Hindi wastong Rehiyon");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mundo",
        "011": "Kanlurang Africa",
        "013": "Gitnang Amerika",
        "014": "Silangang Africa",
        "015": "Hilagang Africa",
        "017": "Gitnang Africa",
        "018": "Katimugang Africa",
        "021": "Hilagang Amerika",
        "029": "Carribbean",
        "030": "Silangang Asya",
        "034": "Katimugang Asya",
        "035": "Timog-Silangang Asya",
        "039": "Katimugang Europa",
        "053": "Australia at New Zealand",
        "057": "Rehiyong Micronesia",
        "142": "Asya",
        "143": "Gitnang Asya",
        "145": "Kanlurang Asya",
        "150": "Europa",
        "151": "Silangang Europa",
        "154": "Hilagang Europa",
        "155": "Kanlurang Europa",
        "AC": "Acsencion island",
        "AQ": "Antartica",
        "AX": "Aland Islands",
        "CD": "Congo - Kinshasa",
        "CI": "Côte d'Ivoire",
        "CS": "Serbia at Montenegro",
        "DE": "Alemanya",
        "ES": "Espanya",
        "FK": "Falkland Islands",
        "GS": "South Georgia and The South Sandwich Islands",
        "IC": "Canary Island",
        "IT": "Italya",
        "MK": "Macedonia",
        "MM": "Myanmar",
        "PH": "Pilipinas",
        "PN": "Pitcairn",
        "PS": "Palestinian Territory",
        "QO": "Malayong bahagi ng Oceania",
        "RU": "Russian Federation",
        "SH": "St. Helena",
        "SJ": "Svalbard and Jan Mayen Islands",
        "ST": "Sao Tome and Principe",
        "TA": "Tristan de Cunha",
        "UM": "Mga Minor Outlying Island ng Estados Unidos",
        "US": "Estados Unidos",
        "WF": "Wallis and the Futuna Islands",
        "ZZ": "Hindi kilala o Hindi wastong Rehiyon"
    };
  }-*/;
}
