/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.server.AbstractPropertyConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.startup.AbstractConfigurationFactory;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.ApplicationConfigurationFactory;
import elemental.json.JsonObject;
import elemental.json.impl.JsonUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ApplicationConfigurationFactory.class}, property={"service.ranking:Integer=-2147483648"})
public class DefaultApplicationConfigurationFactory
extends AbstractConfigurationFactory
implements ApplicationConfigurationFactory {
    @Override
    public ApplicationConfiguration create(VaadinContext context) {
        Objects.requireNonNull(context);
        HashMap<String, String> props = new HashMap<String, String>();
        Enumeration<String> paramNames = context.getContextParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = paramNames.nextElement();
            props.put(name, context.getContextParameter(name));
        }
        JsonObject buildInfo = null;
        try {
            String content = this.getTokenFileContent(props::get);
            if (content == null) {
                content = this.getTokenFileFromClassloader(context);
            }
            JsonObject jsonObject = buildInfo = content == null ? null : (JsonObject)JsonUtil.parse((String)content);
            if (buildInfo != null) {
                props.putAll(this.getConfigParametersUsingTokenData(buildInfo));
            }
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        return this.doCreate(context, props);
    }

    protected ApplicationConfigurationImpl doCreate(VaadinContext context, Map<String, String> properties) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(properties);
        return new ApplicationConfigurationImpl(context, properties);
    }

    protected String getTokenFileFromClassloader(VaadinContext context) throws IOException {
        String tokenResource = "META-INF/VAADIN/config/flow-build-info.json";
        Lookup lookup = context.getAttribute(Lookup.class);
        ResourceProvider resourceProvider = lookup.lookup(ResourceProvider.class);
        List<URL> resources = resourceProvider.getApplicationResources(tokenResource);
        URL resource = resources.stream().filter(url -> !url.getPath().endsWith("jar!/" + tokenResource)).findFirst().orElse(null);
        if (resource == null && !resources.isEmpty()) {
            return this.getPossibleJarResource(context, resources);
        }
        return resource == null ? null : FrontendUtils.streamToString(resource.openStream());
    }

    private String getPossibleJarResource(VaadinContext context, List<URL> resources) throws IOException {
        Objects.requireNonNull(resources);
        Lookup lookup = context.getAttribute(Lookup.class);
        ResourceProvider resourceProvider = lookup.lookup(ResourceProvider.class);
        assert (!resources.isEmpty()) : "Possible jar resource requires resources to be available.";
        URL viteGenerated = resourceProvider.getApplicationResource("vite.generated.ts");
        if (viteGenerated != null && this.countInstances(viteGenerated.getPath(), "jar!/") >= 2) {
            for (URL resource : resources) {
                if (this.countInstances(resource.getPath(), "jar!/") != 1) continue;
                return FrontendUtils.streamToString(resource.openStream());
            }
        }
        URL firstResource = resources.get(0);
        if (resources.size() > 1) {
            String warningMessage = String.format("Unable to fully determine correct flow-build-info.%nAccepting file '%s' first match of '%s' possible.%nPlease verify flow-build-info file content.", firstResource.getPath(), resources.size());
            this.getLogger().warn(warningMessage);
        } else {
            String debugMessage = String.format("Unable to fully determine correct flow-build-info.%nAccepting file '%s'", firstResource.getPath());
            this.getLogger().debug(debugMessage);
        }
        return FrontendUtils.streamToString(firstResource.openStream());
    }

    private int countInstances(String input, String value) {
        return input.split(value, -1).length - 1;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(DefaultApplicationConfigurationFactory.class);
    }

    protected static class ApplicationConfigurationImpl
    extends AbstractPropertyConfiguration
    implements ApplicationConfiguration {
        private final VaadinContext context;

        protected ApplicationConfigurationImpl(VaadinContext context, Map<String, String> properties) {
            super(properties);
            this.context = context;
        }

        @Override
        public boolean isProductionMode() {
            return this.getBooleanProperty("productionMode", false);
        }

        @Override
        public Enumeration<String> getPropertyNames() {
            return Collections.enumeration(this.getProperties().keySet());
        }

        @Override
        public VaadinContext getContext() {
            return this.context;
        }

        @Override
        public boolean isDevModeSessionSerializationEnabled() {
            return this.getBooleanProperty("devmode.sessionSerialization.enabled", false);
        }
    }
}

