/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendPluginsUtil;
import com.vaadin.flow.server.frontend.Options;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskInstallFrontendBuildPlugins
implements FallibleCommand {
    private File targetFolder;

    public TaskInstallFrontendBuildPlugins(Options options) {
        this.targetFolder = new File(options.getBuildDirectory(), "plugins");
    }

    @Override
    public void execute() {
        FrontendPluginsUtil.getPlugins().forEach(plugin -> {
            try {
                this.generatePluginFiles((String)plugin);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Installation of Flow webpack plugin '" + plugin + "' failed", ioe);
            }
        });
    }

    private void generatePluginFiles(String pluginName) throws IOException {
        String packageFile;
        JsonObject targetJson;
        File pluginTargetFile = new File(this.targetFolder, pluginName);
        String pluginFolderName = "plugins/" + pluginName + "/";
        JsonObject packageJson = FrontendPluginsUtil.getJsonFile(pluginFolderName + "package.json");
        if (packageJson == null) {
            this.log().error("Couldn't locate '{}' for plugin '{}'. Plugin will not be installed.", (Object)"package.json", (Object)pluginName);
            return;
        }
        if (pluginTargetFile.exists() && new File(pluginTargetFile, "package.json").exists() && (targetJson = Json.parse((String)(packageFile = FileUtils.readFileToString((File)new File(pluginTargetFile, "package.json"), (Charset)StandardCharsets.UTF_8)))).hasKey("update") && !targetJson.getBoolean("update")) {
            return;
        }
        FileUtils.forceMkdir((File)pluginTargetFile);
        JsonArray files = packageJson.getArray("files");
        for (int i = 0; i < files.length(); ++i) {
            String file = files.getString(i);
            FileUtils.copyURLToFile((URL)FrontendPluginsUtil.getResourceUrl(pluginFolderName + file), (File)new File(pluginTargetFile, file));
        }
        FileUtils.copyURLToFile((URL)FrontendPluginsUtil.getResourceUrl(pluginFolderName + "package.json"), (File)new File(pluginTargetFile, "package.json"));
    }

    private Logger log() {
        return LoggerFactory.getLogger(TaskInstallFrontendBuildPlugins.class);
    }
}

