/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.ParameterDeserializer;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.internal.AbstractRouteRegistry;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class RouteConfiguration
implements Serializable {
    private RouteRegistry handledRegistry;

    private RouteConfiguration(RouteRegistry registry) {
        this.handledRegistry = registry;
    }

    public static RouteConfiguration forSessionScope() {
        return new RouteConfiguration(RouteConfiguration.getSessionRegistry());
    }

    public static RouteConfiguration forApplicationScope() {
        return new RouteConfiguration(RouteConfiguration.getApplicationRegistry());
    }

    public static RouteConfiguration forRegistry(RouteRegistry registry) {
        return new RouteConfiguration(registry);
    }

    public List<RouteData> getAvailableRoutes() {
        return this.handledRegistry.getRegisteredRoutes();
    }

    public boolean isPathAvailable(String path) {
        if (this.handledRegistry instanceof AbstractRouteRegistry) {
            return ((AbstractRouteRegistry)this.handledRegistry).getConfiguration().hasTemplate(path);
        }
        return this.getAvailableRoutes().stream().anyMatch(routeData -> routeData.getTemplate().equals(path) || routeData.getRouteAliases().stream().anyMatch(routeAliasData -> routeAliasData.getTemplate().equals(path)));
    }

    public boolean isRouteRegistered(Class<? extends Component> route) {
        return this.handledRegistry.getTemplate(route).isPresent();
    }

    public Optional<Class<? extends Component>> getRoute(String path) {
        return this.getRoute(path, Collections.emptyList());
    }

    public Optional<Class<? extends Component>> getRoute(String path, List<String> segments) {
        return this.handledRegistry.getNavigationTarget(PathUtil.getPath(path, segments));
    }

    public Registration addRoutesChangeListener(RoutesChangedListener listener) {
        return this.handledRegistry.addRoutesChangeListener(listener);
    }

    public void update(Command command) {
        this.handledRegistry.update(command);
    }

    public void setAnnotatedRoute(Class<? extends Component> navigationTarget) {
        if (!navigationTarget.isAnnotationPresent(Route.class)) {
            String message = String.format("Given navigationTarget %s is missing the '@Route' annotation.", navigationTarget.getName());
            throw new InvalidRouteConfigurationException(message);
        }
        String route = RouteUtil.getRoutePath(this.handledRegistry.getContext(), navigationTarget);
        this.handledRegistry.setRoute(route, navigationTarget, RouteUtil.getParentLayouts(this.handledRegistry.getContext(), navigationTarget, route));
        for (RouteAlias alias : (RouteAlias[])navigationTarget.getAnnotationsByType(RouteAlias.class)) {
            String path = RouteUtil.getRouteAliasPath(navigationTarget, alias);
            this.handledRegistry.setRoute(path, navigationTarget, RouteUtil.getParentLayouts(this.handledRegistry.getContext(), navigationTarget, path));
        }
    }

    public void setParentAnnotatedRoute(String path, Class<? extends Component> navigationTarget) {
        this.handledRegistry.setRoute(path, navigationTarget, RouteUtil.getParentLayoutsForNonRouteTarget(navigationTarget));
    }

    public void setRoute(String path, Class<? extends Component> navigationTarget) {
        this.setRoute(path, navigationTarget, Collections.emptyList());
    }

    public void setRoute(String path, Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentChain) {
        this.handledRegistry.setRoute(path, navigationTarget, parentChain);
    }

    public void setRoute(String path, Class<? extends Component> navigationTarget, Class<? extends RouterLayout> ... parentChain) {
        this.handledRegistry.setRoute(path, navigationTarget, Arrays.asList(parentChain));
    }

    public void removeRoute(Class<? extends Component> navigationTarget) {
        this.handledRegistry.removeRoute(navigationTarget);
    }

    public void removeRoute(String path) {
        this.handledRegistry.removeRoute(path);
    }

    public void removeRoute(String path, Class<? extends Component> navigationTarget) {
        this.handledRegistry.removeRoute(path, navigationTarget);
    }

    public RouteRegistry getHandledRegistry() {
        return this.handledRegistry;
    }

    public String getUrl(Class<? extends Component> navigationTarget) {
        return this.getUrl(navigationTarget, RouteParameters.empty());
    }

    public Optional<String> getUrlBase(Class<? extends Component> navigationTarget) {
        Optional<String> template = this.getTemplate(navigationTarget);
        if (template.isPresent()) {
            return Optional.of(HasUrlParameterFormat.getUrlBase(template.get()));
        }
        return Optional.empty();
    }

    public Optional<String> getTemplate(Class<? extends Component> navigationTarget) {
        return this.handledRegistry.getTemplate(navigationTarget);
    }

    public <T, C extends Component> String getUrl(Class<? extends C> navigationTarget, T parameter) {
        return this.getUrl(navigationTarget, HasUrlParameterFormat.getParameters(parameter));
    }

    public <T, C extends Component> String getUrl(Class<? extends C> navigationTarget, List<T> parameters) {
        return this.getUrl(navigationTarget, HasUrlParameterFormat.getParameters(parameters));
    }

    public String getUrl(Class<? extends Component> navigationTarget, RouteParameters parameters) {
        Optional<String> targetUrl = this.handledRegistry.getTargetUrl(navigationTarget, parameters);
        if (!targetUrl.isPresent()) {
            throw new NotFoundException(String.format("No route found for the given navigation target '%s' and parameters '%s'", navigationTarget.getName(), parameters.toString()));
        }
        return targetUrl.get();
    }

    private static RouteRegistry getApplicationRegistry() {
        return ApplicationRouteRegistry.getInstance(VaadinService.getCurrent().getContext());
    }

    private static RouteRegistry getSessionRegistry() {
        return SessionRouteRegistry.getSessionRegistry(VaadinSession.getCurrent());
    }

    @SafeVarargs
    private final boolean isAnnotatedParameter(Class<? extends Component> navigationTarget, Class<? extends Annotation> ... parameterAnnotations) {
        for (Class<? extends Annotation> annotation : parameterAnnotations) {
            if (!ParameterDeserializer.isAnnotatedParameter(navigationTarget, annotation)) continue;
            return true;
        }
        return false;
    }
}

