/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.shared.Registration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionCache<C, T> {
    private static final Set<Runnable> clearAllActions = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final ConcurrentHashMap<Class<? extends C>, T> values = new ConcurrentHashMap();
    private final SerializableFunction<Class<? extends C>, T> valueProvider;
    private final SerializableRunnable clearAction = this::clear;

    public ReflectionCache(SerializableFunction<Class<C>, T> valueProvider) {
        if (valueProvider == null) {
            throw new IllegalArgumentException("value provider cannot be null");
        }
        this.valueProvider = ReflectionCache.wrapValueProvider(valueProvider);
        ReflectionCache.addClearAllAction(this.clearAction);
    }

    private static <C, T> SerializableFunction<Class<? extends C>, T> wrapValueProvider(SerializableFunction<Class<C>, T> valueProvider) {
        return type -> {
            Map<Class<?>, CurrentInstance> instances = CurrentInstance.getInstances();
            try {
                CurrentInstance.clearAll();
                Object r = valueProvider.apply((Class)type);
                return r;
            }
            finally {
                CurrentInstance.restoreInstances(instances);
            }
        };
    }

    public T get(Class<? extends C> type) {
        return this.values.computeIfAbsent(type, this.valueProvider);
    }

    public boolean contains(Class<? extends C> type) {
        return this.values.containsKey(type);
    }

    public void clear() {
        this.values.clear();
    }

    public static Registration addClearAllAction(Runnable action) {
        return Registration.addAndRemove(clearAllActions, action);
    }

    public static void clearAll() {
        clearAllActions.forEach(Runnable::run);
    }
}

